/*
    PopupMenu.PRG

    Copyright (c) 1991, 1992 Chris Muller and Anton van Straaten

    Fri  10-16-1992  21:55:38 avs - updated
*/

#include "class(y).ch"
#include "csywin.ch"


CREATE CLASS PopupMenu FROM BaseMenu
PROTECTED:
    VAR     window
    VAR     width

    METHOD  menuTop, menuLeft

EXPORT:
    METHOD  init
    METHOD  draw
    METHOD  addItem
    METHOD  exec

    // we must override parent's DEFERRED messages, but this class
    // doesn't need to do anything with them, so map them to NULL.
    MESSAGE setKeys     IS NULL
    MESSAGE clearKeys   IS NULL
END CLASS


/*
    init()

    The ::width variable must be initialized before the superclass'
    initializer is invoked, so we aren't use the extended METHOD
    syntax below.  Instead, the superclass' initializer
    is invoked explicitly with the statement ::super:init(...).
*/

METHOD init( aItems )
    ::width := 0
    ::super:init( aItems )
RETURN self


METHOD draw()
    LOCAL bottom, right

    IF ::window == NIL
        bottom := ::menuTop + len(::items) + 1
        right  := ::menuLeft + ::width + 1
        ::window := Window():new( ::menuTop, ::menuLeft, ;
                                  bottom, right, SNGLBORD )
    END
    ::super:draw()
RETURN self


METHOD menuTop
RETURN winTop() + ::parent:newMenuPos()


METHOD menuLeft
RETURN winLeft() + 2


METHOD addItem( cLabel, oAction, isActive )
    LOCAL nRow

    // establish screen row for new option
    IF LEN( ::items ) == 0
        nRow := 0
    ELSE
        nRow := ATAIL( ::items ):nextRow
    END

    ::super:addItem( nRow, 0, cLabel, oAction, isActive )
    ::width := MAX( ::width, LEN( cLabel ) )
RETURN self


METHOD exec( oParent )
    // invoke the exec method in the superclass (BaseMenu)
    ::super:exec( oParent )
    ::window:kill()
    ::window := NIL
RETURN self


// eof popupmen.prg
