/*
    MenuItem.prg

    Copyright (c) 1991, 1992 Chris Muller and Anton van Straaten
*/

#include "class(y).ch"
#include "csywin.ch"    // Class(y) sample window library header file
#include "csygen.ch"    // for IfNil()


CREATE CLASS MenuItem
    VAR     label
    VAR     action

EXPORT:
    VAR     row, col    READONLY
    VAR     isActive    READONLY

    METHOD  init
    METHOD  draw
    MESSAGE exec TO action
    METHOD  nextCol
    METHOD  nextRow
END CLASS


METHOD init( nRow, nCol, cLabel, oAction, isActive ), ()
    ::row      := nRow
    ::col      := nCol
    ::label    := cLabel
    ::action   := oAction
    ::isActive := IfNil( isActive, .T. )
RETURN self


METHOD draw
    IF ::isActive
        @ ::row, ::col PROMPT ::label
    ELSE
        @ ::row, ::col SAY ::label
    END
RETURN self


METHOD nextRow
RETURN ::row + 1


METHOD nextCol
RETURN ::col + LEN( ::label )


// eof menuitem.prg
