/*
    MenuDemo.prg

    Class(y) menu demonstration - for tutorial example

    Fri  10-16-1992  22:06:02 avs - updated
*/

PROCEDURE Main
    LOCAL oMenuBar, oSaveMenu, oFileMenu, oWindowMenu, oBlockMenu

    // to keep the syntax (reasonably) simple, we create the submenus first:
    oSaveMenu := PopupMenu():new( { { " Document ", { || SaveDoc()  } }, ;
                                    { " Text     ", { || SaveText() } }  ;
                                 } )

    oFileMenu := PullDnMenu():new( { { " Load ", { || LoadFile() } }, ;
                                     { " Edit ", { || EditFile() } }, ;
                                     { " Save ", oSaveMenu }          ;
                                   } )

    oWindowMenu := PullDnMenu():new( { { " Close ", { || CloseWin() } }, ;
                                       { " Split ", { || SplitWin() } }, ;
                                       { " Next  ", { || NextWin()  } }  ;
                                     } )


    oBlockMenu := PullDnMenu():new( { { " Mark Line      ", { || MarkLine() } }, ;
                                      { " Mark Character ", { || MarkChar() } }, ;
                                      { " Mark Column    ", { || MarkCol()  } }  ;
                                    } )

    oMenuBar := MenuBar():new( { { " File ",   oFileMenu   }, ;
                                 { " Window ", oWindowMenu }, ;
                                 { " Block ",  oBlockMenu  }  ;
                               } )

    /*
        An alternative technique would be to add items
        to the menus one at a time, as follows:

        oMenuBar := MenuBar():new

        oMenuBar:addItem(" File ",   oFileMenu)
        oMenuBar:addItem(" Window ", oWindowMenu)
        oMenuBar:addItem(" Block ",  oBlockMenu)
    */

    CLS
    SET WRAP ON
    SetColor('N/W, W/N')

    // execute the menu:
    oMenuBar:exec()

RETURN

// these are just stubs, so let's cut corners...
PROCEDURE SaveDoc;  dummy(); RETURN
PROCEDURE SaveText; dummy(); RETURN
PROCEDURE LoadFile; dummy(); RETURN
PROCEDURE EditFile; dummy(); RETURN
PROCEDURE CloseWin; dummy(); RETURN
PROCEDURE SplitWin; dummy(); RETURN
PROCEDURE NextWin;  dummy(); RETURN
PROCEDURE MarkLine; dummy(); RETURN
PROCEDURE MarkChar; dummy(); RETURN
PROCEDURE MarkCol;  dummy(); RETURN

PROCEDURE dummy
    @ 24, 0 SAY PROCNAME( 1 ) + " - press a key..."
    INKEY( 0 )
    @ 24, 0
RETURN


// eof menudemo.prg
