/*
    MenuBar.PRG

    Copyright (c) 1991 Chris Muller and Anton van Straaten

    Fri  10-16-1992  22:07:04 avs - updated
*/

#include "class(y).ch"

#define OPTION_SPACING  4


CREATE CLASS MenuBar FROM BaseMenu
EXPORT:
    METHOD  draw
    METHOD  addItem
    METHOD  newMenuPos

    // we must override parent's DEFERRED messages, but this class
    // doesn't need to do anything with them, so map them to NULL.
    MESSAGE setKeys     IS NULL
    MESSAGE clearKeys   IS NULL
END CLASS
       

METHOD addItem( cLabel, oAction, isActive )
    LOCAL nCol

    // establish screen column for new option
    IF len(::items) == 0
        nCol := OPTION_SPACING
    ELSE
        nCol := ATAIL( ::items ):nextCol() + OPTION_SPACING
    END

    // invoke addItem in the superclass (BaseMenu)
    ::super:addItem( 0, nCol, cLabel, oAction, isActive )
RETURN self


METHOD draw()
    winCurrent(0)       // selects main screen
    @ 0, 0              // draw the bar
    ::super:draw()      // invoke superclass' draw method
RETURN self


METHOD newMenuPos
// tells a child menu where to put itself
RETURN ::items[ ::currPos ]:col


// eof menubar.prg
