/*
    cursor.prg

    Copyright (c) 1991 Anton van Straaten

    Definition of class cursor
*/

#include "class(y).ch"


CREATE CLASS Cursor
    VAR shape

EXPORT:
    VAR row, col READONLY
    VAR color    READONLY

    METHOD  init
    METHOD  show
    METHOD  hide
    METHOD  update
    METHOD  up
    METHOD  down
    MESSAGE left  METHOD cursleft       // left() and right() are reserved
    MESSAGE right METHOD cursright      // function names in Clipper.
END CLASS



METHOD init( row, col, shape, color ), ()
    ::update()
    ::row := row
    ::col := col
    ::shape := shape
    ::color := color
RETURN self


METHOD update()
    ::row   := ROW()
    ::col   := COL()
    ::shape := SetCursor()
    ::color := SetColor()
RETURN self


METHOD show()
    SetPos( ::row, ::col )
    SetCursor( ::shape )
    SetColor( ::color )
RETURN self


METHOD hide( lNoUpdate )
    IF lNoUpdate == NIL .OR. !lNoUpdate
        ::update()
    END
    SetCursor( 0 )
RETURN self


METHOD up( n )
    ::row -= IF( n == NIL, 1, n )
    IF ::row < 0
        ::row := 0
    END
    SetPos(::row, ::col)
RETURN self


METHOD down( n )
    ::row += IF( n == NIL, 1, n )
    if ::row > MAXROW()
        ::row := MAXROW()
    end
    SetPos( ::row, ::col )
RETURN self


METHOD cursLeft( n )
    ::col -= IF( n == NIL, 1, n )
    IF ::col < 0
        ::col := 0
    END
    SetPos(::row, ::col)
RETURN self



METHOD cursRight( n )
    ::col += IF( n == NIL, 1, n )
    IF ::col > MAXCOL()
        ::col := MAXCOL()
    END
    SetPos( ::row, ::col )
RETURN self


// eof cursor.prg
