/*
    win.ch

    Copyright (c) 1991 Anton van Straaten
*/

/*
    the following can be passed to the 'new' message for the Window
    class to specify the type of border desired.  They differ from
    the definitions in Clipper's BOX.CH by having a trailing blank,
    which causes the interior of the window to be filled.
*/

#define     NOBORDER    ""
#define     SNGLBORD    "Ŀ "
#define     DUBLBORD    "ͻȺ "


/*
    the following are constants used as parameters to the 'title' message,
    to position window titles as desired.
*/

#xtranslate  wTL =>  -1      // top left
#xtranslate  wTC =>  -2      // top centre
#xtranslate  wTR =>  -3      // top right
#xtranslate  wBL =>  -4      // bottom left
#xtranslate  wBC =>  -5      // bottom centre
#xtranslate  wBR =>  -6      // bottom right

#translate  row()       =>  winrow()
#translate  col()       =>  wincol()
#translate  maxrow()    =>  winmaxrow()
#translate  maxcol()    =>  winmaxcol()

/*
	The following #command definitions have been adapted from the
        Clipper 5.01 STD.CH header file (copyright Computer Associates)
*/

#command @ <row>, <col> 						 ;
      => Scroll( <row> + wintop(), <col> + winleft(), <row> + wintop() ) ;
       ; SetPos( <row> + wintop(), <col> + winleft())

#command @ <top>, <left> CLEAR                                          ;
      => Scroll( <top> + wintop(), <left> + winleft() )                 ;
       ; SetPos( <top> + wintop(), <left> + winleft() )

#command @ <top>, <left> CLEAR TO <bottom>, <right>                     ;
      => Scroll( <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft() ) ;
       ; SetPos( <top> + wintop(), <left> + winleft() )


***
*  @..BOX
*

#command @ <top>, <left>, <bottom>, <right> BOX <string>                ;
                                            [COLOR <color>]             ;
      => DispBox(                                                       ;
		  <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft(), <string>    ;
                  [, <color> ]                                          ;
                )


#command @ <top>, <left> TO <bottom>, <right> [DOUBLE]                  ;
                                              [COLOR <color>]           ;
      => DispBox(                                                       ;
		  <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft(), 2   ;
                  [, <color> ]                                          ;
                )


#command @ <top>, <left> TO <bottom>, <right> [COLOR <color>]           ;
                                                                        ;
      => DispBox(                                                       ;
		  <top> + wintop(), <left> + winleft(), <bottom> + wintop(), <right> + winleft(), 1   ;
                  [, <color> ]                                          ;
                )

***
*  @..SAY
*

#command @ <row>, <col> SAY <xpr>                                       ;
                        [PICTURE <pic>]                                 ;
                        [COLOR <color>]                                 ;
                                                                        ;
      => DevPos( <row> + wintop(), <col> + winleft() )                  ;
       ; DevOut( _wintrunc( transform( <xpr>, <pic> ), <col> ) [, <color>] )


#command @ <row>, <col> SAY <xpr>                                       ;
                        [COLOR <color>]                                 ;
                                                                        ;
      => DevPos( <row> + wintop(), <col> + winleft() )                  ;
       ; DevOut( _wintrunc( transform( <xpr>, '' ), <col> ) [, <color>] )


***
*  @..GET
*

#command @ <row>, <col> GET <var>                                       ;
                        [PICTURE <pic>]                                 ;
                        [VALID <valid>]                                 ;
                        [WHEN <when>]                                   ;
                        [SEND <msg>]                                    ;
                                                                        ;
      => SetPos( <row> + wintop(), <col> + winleft() )                  ;
       ; AAdd(                                                          ;
               GetList,                                                 ;
               _GET_( <var>, <(var)>, <pic>, <{valid}>, <{when}> )      ;
             )                                                          ;
      [; ATail(GetList):<msg>]


#command @ <row>, <col> PROMPT <prompt> [MESSAGE <msg>] 		;
      => __AtPrompt( <row> + wintop(), <col> + winleft(), _wintrunc( <prompt>, <col> ), <msg> )


// eof win.ch
