/*
    csylist.prg

    Copyright (c) 1991, 1992 Anton van Straaten

         02-06-1991  02:42:05 avs - creation
    Sun  10-18-1992  08:10:59 avs - update

    A simple sample linked list class.  Used by the sample Window class.
*/

#include "class(y).ch"


CREATE CLASS List
    VAR     items
    VAR     currPos

EXPORT:
    VAR     nSize   READONLY

    METHOD  init

    METHOD  head
    METHOD  tail

    METHOD  next
    METHOD  prev
    METHOD  current

    METHOD  add
    METHOD  insert
    MESSAGE delete  METHOD listdelete           // 'delete' is a reserved word
    METHOD  replace
END CLASS


METHOD init( aItems ), ()
    IF valtype(aItems) == 'A'
        ::items := aItems
    ELSEIF aItems <> NIL
        ::items := { aItems }
    ELSE
        ::items := {}
    END
    ::nSize := LEN( ::items )
    ::currPos := IF( ::nSize > 0, 1, 0 )
RETURN self

METHOD head
RETURN if(::nSize > 0, ::items[::currPos := 1], nil)

METHOD tail
RETURN IF( ::nSize > 0, ::items[::currPos := ::nSize], nil )

METHOD next
RETURN IF( ::currPos < ::nSize, ::items[++::currPos], nil )

METHOD prev
RETURN if( ::currPos > 1, ::items[--::currPos], nil )

METHOD current
RETURN IF( ::currPos > 0, ::items[::currPos], nil )

METHOD add(item)
    AADD( ::items, item )
    ::currPos := ++::nSize
RETURN item

METHOD listdelete()
    IF ::nSize > 0
        ADEL(::items, ::currPos)
        ASIZE(::items, --::nSize)
        IF ::nSize == 0
            ::currPos := 0
        END
    END
RETURN self

METHOD insert( item )
    ASIZE( ::items, ++::nSize )
    IF ::currPos == 0
        ++::currPos
    END
    AINS( ::items, ::currPos )
RETURN ::items[::currPos] := item

METHOD replace( item )
RETURN if(::currPos > 0, ::items[::currPos] := item, nil)


// eof csylist.prg
