/*
    BaseMenu.prg

    Copyright (c) 1991, 1992 Chris Muller and Anton van Straaten
*/

#include "class(y).ch"


CREATE CLASS BaseMenu
PROTECTED:
    VAR items
    VAR currPos
    VAR parent

EXPORT:
    METHOD  init
    METHOD  addItem
    METHOD  draw
    METHOD  exec
    METHOD  newMenuPos

    // declaring the following two methods as deferred
    // will force subclasses to override them.
    MESSAGE setKeys     IS DEFERRED
    MESSAGE clearKeys   IS DEFERRED
END CLASS


METHOD init( aItems ), ()
    LOCAL i

    ::items   := {}
    ::currPos := 1

    IF aItems != NIL
        FOR i := 1 TO LEN( aItems )
            // note: following is a bit tricky; invokes addItem in
            // in the subclass, which takes fewer parameters than
            // BaseMenu's addItem.
            ::addItem( aItems[i, 1], aItems[i, 2] )
        NEXT
    END
RETURN self


METHOD draw()
    LOCAL i

    FOR i := 1 TO LEN( ::items )
        ::items[i]:draw()
    NEXT i
RETURN self


METHOD addItem( nRow, nCol, cLabel, oAction, lActive )
    AADD( ::items, MenuItem():new( nRow, nCol, cLabel, ;
                                    oAction, lActive ) )
RETURN self


METHOD exec( oParent )
    LOCAL finished := .f.

    ::parent := oParent

    WHILE !finished
        ::draw()

        ::setKeys()
        MENU TO ::currPos
        ::clearKeys()

        finished := ( ::currPos == 0 )

        IF !finished
            ::items[::currPos]:exec( self )
        END
    END
RETURN self


METHOD newMenuPos
RETURN ::currPos


// eof basemenu.prg
