/*
    htbox.prg

    Companion program to HERITEST.PRG.
*/

#include "class(y).ch"


CREATE CLASS Box FROM Rectangle
    VAR     boxChars
    VAR     frameColor
    VAR     paneColor

PROTECTED:
    VAR     boxType

EXPORT:
    CLASS VAR nBoxes

    METHOD  init
    METHOD  draw
    METHOD  test

END CLASS


METHOD init( nTop, nLeft, nBottom, nRight, cFrame, cFrameColor, cPaneColor ), ;
    ( nTop, nLeft, nBottom, nRight )

    ::boxChars   := cFrame
    ::frameColor := cFrameColor
    ::paneColor  := cPaneColor

    ::draw()
RETURN self


METHOD draw
    SetColor( ::frameColor )
    @ ::top, ::left, ::bottom, ::right BOX ::boxChars
    SetColor( ::paneColor )
    @ ::top + 1, ::left + 1 CLEAR TO ::bottom - 1, ::right - 1
RETURN self


METHOD test
    // print a message to indicate which method is executing
    ? 'Executing Box:test'
RETURN self


// eof htbox.prg
