/*
    heritest.prg

    21/03/1991 21:18 avs - updated
    26/05/1991 07:36 avs - updated

    This program demonstrates many of the inheritance and scoping features
    of Class(y), as well as some of the more advanced features.  The
    program displays a menu of options; many of which will generate an
    error when selected.  In these cases, an illegal operation has
    deliberately been performed.

    NOTE: The output from this program is not very informative in itself.
    We suggest that you trace through the program in the Clipper debugger,
    and examine variable values as necessary.

    The program uses a box class, defined in HTBOX.PRG, which is inherited
    from the rectangle class defined in this module.  The Rectangle class is
    very primitve, and is not the same one used in the manual.
*/

#include "class(y).ch"


PROCEDURE main
    LOCAL i, ivar, oBox, tStart
    LOCAL BoxClass
    LOCAL opt := 1

    CLS
    oBox := Box():new(2, 5, 16, 24, "ͻȺ ", "R+/W", "RB+/BG")

    WHILE opt <> 0
        @  2, 12 say          'Errors'
        @  3,  6 prompt ' Private access   '
        @  4,  6 prompt ' Protected access '
        @  5,  6 prompt ' Bad assignment   '
        @  6,  6 prompt ' Msg -> non-obj   '
        @  7,  6 prompt ' Bad message      '
        @  8,  6 prompt ' Access via class '
        @  9,  6 say    'Tests'
        @ 10,  6 prompt ' Self in block    '
        @ 11,  6 prompt ' Scalar classes   '
        @ 12,  6 prompt ' Superclass name  '
        @ 13,  6 prompt ' Class scope msgs '
        @ 14,  6 prompt ' Class variables  '
        @ 15,  6 prompt ' Class objects    '
        MENU TO opt
        SET COLOR TO 'W/N'
        @ 20, 0
        DO CASE
            /*
                The following six options test variable scoping features
                and so forth, and all intentionally cause an error.
            */
            CASE opt == 1
                // illegal access of a private instance variable
                ? oBox:boxChars
            CASE opt == 2
                // illegal access of a protected instance variable
                ? oBox:boxType

            CASE opt == 3
                // illegal assignment to read-only variable
                oBox:top := 42
            CASE opt == 4
                // sending a message to a non-object
                ? opt:boxChars
            CASE opt == 5
                // sending an unknown message to an object
                ? oBox:volume
            CASE opt == 6
                // attempting to access an _instance_ variable via the
                // class function ie. without using an object of that class.
                ? box():top
            /*
                The following options demonstrate and test various
                Class(y) features.  These should not cause errors.
            */
            CASE opt == 7
                // Accessing the 'self' variable within a code block
                // (see the 'testBlock' method)
                oBox:testBlock()
            CASE opt == 8
                // Sending messages to the 'scalar' types such as numeric,
                // character etc (see the 'scalarClasses()' function).
                scalarClasses()
            CASE opt == 9
                // Explicitly accessing an object's superclass with the
                // 'super' message.  In this case, we print the name of
                // the superclass using the 'className' message.
                ? "Using :super to access the name of an object's superclass"
                ? 'oBox:super:className -', oBox:super:className
            CASE opt == 10
                // Another test of the 'super' message, comparing it with
                // using a specific class name ('rectangle') to specify
                // where to begin a message search.

                ? 'See HERITEST.PRG for explanation'
                // First invoke method 'test' in class Box
                oBox:test()
                // Now invoke the same method in the Box's superclass, which
                // in this example is Rectangle.  Use the 'super' message.
                oBox:super:test()
                // Invoke it in Box again, to check that nothing is 'stuck'
                oBox:test()
                // invoke in class Rectangle by naming the class explicitly
                oBox:rectangle:test()
                // and Box again, as a final check
                oBox:test()
            CASE opt == 11
                // Test class variables, which apply to an entire class rather
                // than to an individual object, or instance of the class.
                // First access class variables via an object.
                oBox:class:nRects := 42
                oBox:class:nBoxes := 23
                ? 'Accessing :nRects and :nBoxes via the oBox object:'
                ? oBox:class:nRects, oBox:class:nBoxes
                // Now access them via the 'class functions'.  Note that the
                // same values are printed, since they are the same variables.
                ? 'Do the same use the Box() class function:'
                ? Box():nRects, Box():nBoxes
                ? 'And access :nRects via the Rectangle() class function,'
                ? 'giving a different copy of nRects which has not been set:'
                ? Rectangle():nRects
            CASE opt == 12
                // Use the predefined 'class' message to obtain an object's
                // 'class object'.  A class object contains any class variables
                // that a class has.
                BoxClass := oBox:class
                ? 'Access class variables via a class object:'
                ? BoxClass:nBoxes
                // The class function also returns a class object.  We can
                // check that these are the same as follows:
                ? 'Check that class object is same as returned by class function:'
                ? (BoxClass == Box())
        END
        IF opt <> 0
            WAIT
            CLS
            oBox:draw()
        END
    END
RETURN


/*
    Using Class(y), the scalar types (eg. NUMERIC, DATE etc) accept the
    CLASSNAME and CLASSH messages, as they do in standard Clipper 5.01. In
    all object classes, 'classH' returns a number identifying the class.
    This can be used to test whether two objects belong to the same class,
    for example.  The built in data types all respond to the 'classH'
    message with zero.
*/

STATIC PROCEDURE scalarClasses
    LOCAL i
    // set up an array of the simple types: code block, nil, numeric, logical, character, array, date
    LOCAL aTypes := { { || qout("wow") }, nil, 2, .t., "wow", array(4), date() }

    ? 'Simple (scalar) variable type response to standard messages'
    ?
    ? '    classH  VALTYPE()  className'
    FOR i := 1 to LEN( aTypes )
        ? aTypes[i]:classH, '    ', VALTYPE( aTypes[i] ), '    ', aTypes[i]:className
    NEXT
RETURN


/*
    Define the Rectangle class
*/

CREATE CLASS Rectangle

EXPORT:
    CLASS VAR nRects

    VAR     top, left, bottom, right    READONLY
    VAR     width, height               READONLY

    METHOD  init
    METHOD  set
    METHOD  test
    METHOD  testBlock

END CLASS


METHOD init( nTop, nLeft, nBottom, nRight ), ()
    ::set( nTop, nLeft, nBottom, nRight )
RETURN self


METHOD set( nTop, nLeft, nBottom, nRight )
    ::top    := nTop
    ::left   := nLeft
    ::bottom := nBottom
    ::right  := nRight

    ::width  := nBottom - nTop
    ::height := nRight - nLeft
RETURN self


METHOD test
    // print a message to indicate which method is executing
    ? 'Executing Rectangle:test'
RETURN self


/*
    :testBlock

    Test the accessing of an instance variable within a code block.
*/

METHOD testBlock
    LOCAL b := { || ::top }
    ? 'Accessing an instance variable within a code block:'
    ? 'self:top =', EVAL( b )
RETURN self


// eof heritest.prg
