/*
    dict.prg

    Copyright (c) 1992 John F Kaster and Anton van Straaten
    Portions adapted from Clipper sample program DICT.PRG,
    copyright (c) 1992 Computer Associates.
*/


#include "class(y).ch"
#include "csygen.ch"


#define     DEFAULT_HASH_SIZE   31
#define     MAX_BUCKETS         4096



CREATE CLASS Dictionary
    VAR         buckets

    METHOD      grow
    METHOD      getBucket

EXPORT:
    METHOD      init
    MESSAGE     at METHOD get   // can't use 'at' coz it's reserved by Clipper
    METHOD      get
    METHOD      put
    METHOD      putAssoc
    METHOD      remove
    METHOD      do
END CLASS


METHOD init( nHashSize ), ()
    LOCAL i

    DEFAULT nHashSize TO DEFAULT_HASH_SIZE

    ::buckets := ARRAY( nHashSize )

    FOR i := 1 TO nHashSize
        ::buckets[i] := {}
    NEXT
RETURN self


METHOD getBucket( cKey, nAssoc )
    LOCAL bucket := ::buckets[ CsyHashVal( cKey, LEN( ::buckets ) ) ]
    LOCAL nPos   := nAssoc := 0

    FOR nPos := 1 TO LEN( bucket )
        IF bucket[nPos]:key == cKey
            nAssoc := nPos
            EXIT
        END
    NEXT

RETURN bucket


METHOD get( cKey )
    LOCAL nAssoc
    LOCAL bucket := ::getBucket(cKey, @nAssoc)
RETURN IF( nAssoc == 0, NIL, bucket[ nAssoc ]:value )


METHOD putAssoc( assoc )
    LOCAL nAssoc
    LOCAL bucket := ::getBucket( assoc:key, @nAssoc )

    IF nAssoc == 0
        AAdd( bucket, assoc )
        nAssoc := LEN( bucket )
    ELSE
        bucket[nAssoc] := assoc
    END

    IF nAssoc > 3 .AND. LEN( ::buckets ) < MAX_BUCKETS
        ::grow()        // this bucket is big, grow dict
    END
RETURN self


METHOD put( cKey, value )
    LOCAL assoc := Association():new( cKey, value )
    ::putAssoc( assoc )
RETURN self


METHOD grow
    LOCAL i
    LOCAL nSize   := MIN( LEN( ::buckets ) * 4 - 1, MAX_BUCKETS )
    LOCAL newDict := Dictionary():new(nSize)

    // rehash pairs into dict
    AEval( ::buckets, ;
        { |bucket| AEval( bucket, ;
            { |assoc| newDict:putAssoc( assoc ) } ) } )

    ::buckets := newDict:buckets
RETURN self


METHOD remove( cKey )
    LOCAL nAssoc
    LOCAL bucket := ::getBucket( cKey, @nAssoc )

    IF nAssoc <> 0
        // we use the Array class 'delete' message
        // to delete an element resize the array.
        bucket:delete( nAssoc )
    END
RETURN self


METHOD do( block )
    LOCAL nBucket, nAssoc, bucket
    LOCAL buckets  := ::buckets
    LOCAL nBuckets := LEN( buckets )

    // don't use AEval because of performance
    FOR nBucket := 1 TO nBuckets
        bucket := buckets[ nBucket ]
        FOR nAssoc := 1 to LEN( bucket )
            EVAL( block, bucket[ nAssoc ], nAssoc )
        NEXT
    NEXT
RETURN self


// eof dict.prg
