/*
    csyfile.prg

    Copyright (c) 1991 Anton van Straaten

    13/02/1991 20:56 avs - creation

    A simple encapsulation of the Clipper low-level file i/o functions.
    Limited, but serves as an example of how easily a well-designed
    procedural system can be encapsulated in an object-oriented shell.

    Note that the name 'File' cannot be used for this class because of
    the Clipper function FILE().
*/

#include "class(y).ch"


CREATE CLASS DosFile

EXPORT:
    VAR handle  READONLY
    VAR name    READONLY

    METHOD init
    METHOD open
    METHOD close
    METHOD create
    METHOD read, readStr
    METHOD write

    CLASS METHOD error
    CLASS METHOD erase
    CLASS METHOD exists

END CLASS


METHOD init( cFileName ), ()
    ::name := cFileName
RETURN self

METHOD open(nMode)
RETURN ( ::handle := FOPEN( ::name, nMode ) )

METHOD close
RETURN FCLOSE( ::handle )

METHOD create(nAttribute)
RETURN ::handle := FCREATE( ::name, nAttribute )

METHOD read(buf, nBytes)
RETURN FREAD( ::handle, @buf, nBytes )

METHOD readStr(nBytes)
RETURN FREADSTR( ::handle, nBytes )

METHOD write(buf, nBytes)
RETURN FWRITE( ::handle, buf, nBytes )

// Class methods are defined below

METHOD error
RETURN FERROR()

METHOD erase( cFile )
RETURN FERASE( cFile )

METHOD exists( cFile )
RETURN FILE( cFile )


// eof csyfile.prg
