/*
    arrsize.prg

    Tue  04-14-1992  11:20:59   avs
    Thu  07-30-1992  20:40:47   avs

    This program demonstrates resizing of an array using the default Array
    class, defined in CSYARRAY.PRG.

    The Array class is automatically "attached" to all Clipper arrays,
    allowing them to understand the messages defined by the Array class and
    its superclass, Object.

    The Array class is automatically included in any program which uses
    Class(y), since it is used internally by the Class(y) kernel.

    In this program, since we aren't creating any classes, we have to force
    Class(y) to be linked in using the statement "EXTERNAL Class".
*/

EXTERNAL Class


PROCEDURE Main
    LOCAL arr[10]                           // declare 10-element array

    ? "Original array size:"
    ? "   using LEN(arr)  -", LEN( arr )
    ? "   using arr:size  -", arr:size
    ?

    // change size to 5 (see the '_size' method in CSYARRAY.PRG)
    arr:size := 5

    ? "New array size:"
    ? "   using LEN(arr) -", LEN( arr )
    ? "   using arr:size -", arr:size
    ?
RETURN


// eof arrsize.prg
