/*
    csygen.ch

    Some useful definitions used in the Class(y) sample programs.
*/

// DEFAULT...TO initializes a variable to a default
// value only if the specified variable's value is NIL.

#command    DEFAULT <var> TO <val> [ , <varN> TO <valN> ]   ;
                =>                                          ;
                IF <var>  == NIL; <var>  := <val>;  END     ;
             [; IF <varN> == NIL; <varN> := <valN>; END]


// IfNil() can be used to initialize an instance variable from a parameter.
// If the parameter is NIL, the supplied default value is used instead.
// For example:  ::var := IfNil( xParam, xDefaultVal )

#translate  IfNil( <var>, <val> )   ;
                =>                  ;
                IF( <var> == NIL, <val>, <var> )

// eof csygen.ch
