/*
    csy1sntx.ch

    Supports Class(y) v1.0x command syntax, but does not emulate v1.0x
    behavior, eg. class variable handling, allowing instances to accept
    class messages, and automatic declaration of new/init.

    Sun  09-27-1992  17:08:29   avs
*/


// messages can be sent to the class object in 2.0 without any special setup
#command    INITIALIZE [CLASS] :    =>


// _CSY_CTOR and _CSY_SUPCTOR are internal commands
#xcommand   _CSY_CTOR [<name>]([<params,...>])[()] ;
                => ;
                __cyMethodType procedure CSY_OPT([<name>,] init)(<params>)

#xtranslate _CSY_SUPCTOR [<name>]([<params,...>])[()] ;
                => ;
                qself():super:CSY_OPT([<name>,] init)(<params>)

#command    CONSTRUCTOR [<ctor>] [, <superCtor>]    ;
                =>                                  ;
                _CSY_CTOR <ctor>()                  ;;
                local self := (_CSY_SUPCTOR <superCtor>(), qself())

#command    CONSTRUCTOR new [<params>][, <superParams>] ;
                => ;
                CONSTRUCTOR init <params>[, <superParams>]


#xcommand   LOCAL:      =>  HIDDEN:
#command    PRIVATE:    =>  HIDDEN:

#xcommand   CLASSVAR <*details*>    =>  CLASS VAR <details>
#xcommand   INSTVAR <*details*>     =>  VAR <details>

#xcommand   DECL_METHOD <message1> = <method1> [, <messageN> = <methodN>]   ;
                =>                                                          ;
                MESSAGE <message1> METHOD <method1>                         ;
             [; MESSAGE <messageN> METHOD <methodN>]

#xcommand   METHOD <message> = <method> <ct: CONSTRUCTOR, CTOR> ;
                => ;
                MESSAGE <message> METHOD <method> <ct>

#xcommand   METHOD <method1> [, <methodN>] <clause: DEFERRED, NULL> ;
                => ;
                MESSAGE <method1> [, <methodN>] IS <clause>

#xcommand   CLASS METHOD <message> = <method> ;
                => ;
                CLASS MESSAGE <message> METHOD <method>

#ifndef CSY1 // fully v1.0 compatible alternatives defined in CLASSY1.CH
#xcommand   CLASS METHOD <method1> [, <methodN>] <clause: DEFERRED, NULL> ;
                => ;
                CLASS MESSAGE <method1> [, <methodN>] IS <clause>

#xcommand   CLASS MESSAGE <message1> [, <messageN>] <clause: DEFERRED, NULL> ;
                => ;
                CLASS MESSAGE <message1> [, <messageN>] IS <clause>
#endif

#xcommand   MESSAGE <message1> [, <messageN>] <clause: DEFERRED, NULL>  ;
                =>                                                      ;
                MESSAGE <message1> [, <messageN>] IS <clause>

// To avoid any conflict with a function named MESSAGE(), the
// following command can be commented out and its use avoided.
#command    MESSAGE <message1> [, <messageN>] [<ct: CONSTRUCTOR, CTOR>] ;
                => ;
                METHOD <message1> [, <messageN>] <ct>

#xcommand   CLASS MESSAGE <message1> [, <messageN>] ;
                => ;
                CLASS METHOD <message1> [, <messageN>]


// eof csy1sntx.ch
