/*
    classy2.ch

    Class(y) v2.0 command definitions

    Copyright (c) 1992 Anton van Straaten
*/


#xcommand   CLASS FUNCTION <funcName> [<static: STATIC>] ;
                =>                          ;
                <static> function <funcName>;;
                static self                 ;;
                local metaClass             ;;
                local nScope, initDone      ;;
                if self == NIL              ;;
                    initDone := .f.         ;;
                    nScope := CSY_HIDDEN


#ifndef CSY1
#xcommand   CREATE CLASS <(className)> [<sup: INHERIT, FROM> <superClass>] [METACLASS <metaClass>] [<static: STATIC>] [FUNCTION <funcName>] ;
                =>                                                          ;
                CLASS FUNCTION CSY_OPT([<funcName>,] <className>) <static>  ;;
                self := CSY_OPT([<metaClass>,] Class)():new(<(className)>, CSY_OPT([<superClass>,] Object)()) ;;
                if !<.metaClass.>                                           ;;
                metaClass := Class():new(<(className)> + " class", if( ::superClass == NIL, Class(), ::superClass:class)) ;;
                end                                                         ;;
                #include "newclass.ch"


#xcommand   CREATE CLASS <(className)> <sup: INHERIT, FROM> <superClass1>, <superClass2> [, <superClassN>] [METACLASS <metaClass>] [<static: STATIC>] [FUNCTION <funcName>] ;
                =>                                                          ;
                CLASS FUNCTION CSY_OPT([<funcName>,] <className>) <static>  ;;
                if !<.metaClass.>                                           ;;
                metaClass := MIClass():new(<(className)> + " class", { <superClass1>():class, <superClass2>():class [, <superClassN>():class], MIClass() } ) ;;
                end                                                         ;;
                self := CSY_OPT([<metaClass>,] MIClass)():new(<(className)>, { <superClass1>(), <superClass2>() [, <superClassN>()] } ) ;;
                #include "newclass.ch"


#xcommand   END CLASS [<noinit:NOINIT>]     ;
                =>                          ;
                if !<.noinit.>              ;;
                self:makeClass(metaClass)   ;;
                self:initClass()            ;;
                end; end; return self       ;;
                #include "endclass.ch"
#endif // !CSY1


#xcommand   ENDCLASS        =>  END CLASS

#define     CSY_EXPORTED            1
#define     CSY_PROTECTED           2
#define     CSY_HIDDEN              4

#command    EXPORTED:       =>      nScope := CSY_EXPORTED
#command    VISIBLE:        =>      nScope := CSY_EXPORTED
#command    HIDDEN:         =>      nScope := CSY_HIDDEN
#command    PROTECTED:      =>      nScope := CSY_PROTECTED


// CSY_VARSCOPE() and CSY_OPT() are internal translations used in other commands
#xtranslate CSY_VARSCOPE( <ro> )                    =>  nScope, if( <ro>, nScope * 2, nScope )
#xtranslate CSY_VARSCOPE( <ro>, <assignScope> )     =>  nScope, CSY_ASSIGN <assignScope>

#xtranslate CSY_OPT(<a>,<b>)    =>  <a>
#xtranslate CSY_OPT(<a>)        =>  <a>

// do not modify any of the following values
#xtranslate CSY_TYPE Array      =>  {}
#translate  CSY_TYPE Character  =>  ""
#xtranslate CSY_TYPE Block      =>  { || nil }
#xtranslate CSY_TYPE Numeric    =>  0.1
#xtranslate CSY_TYPE Date       =>  CTOD("")
#xtranslate CSY_TYPE Integer    =>  0
#xtranslate CSY_TYPE Logical    => .t.

// abbreviations
#xtranslate CSY_TYPE Num        =>  CSY_TYPE Numeric
#xtranslate CSY_TYPE Int        =>  CSY_TYPE Integer

#translate  CSY_ASSIGN EXPORTED     =>  CSY_EXPORTED
#translate  CSY_ASSIGN VISIBLE      =>  CSY_EXPORTED
#translate  CSY_ASSIGN PROTECTED    =>  CSY_PROTECTED
#translate  CSY_ASSIGN HIDDEN       =>  CSY_HIDDEN


/*
    VAR                         Declare instance variable(s)
    VAR...IS                    Declare new name for existing variable
    VAR...TO                    Declare delegated variable(s)
    VAR...[IS...] TO            Declare delegated variable
*/

#command    VAR <(name1)> [, <(nameN)>] [CLASS <class>] [TYPE <type>] [<ro: READONLY, RO, NOASSIGN>] [ASSIGN <assignScope>] ;
                => ;
                self:addVars( cmsVariable(), { <(name1)> [, <(nameN)>] }, CSY_VARSCOPE( <.ro.> [, <assignScope>]  ), [<class>()] [CSY_TYPE <type>] )

#command    VAR <(name)> IS <(originalName)> [<ro: READONLY, RO>] [CLASS <class>] [TYPE <type>] [ASSIGN <assignScope>] ;
                => ;
                self:addMsg( cmsVarRedef():new( self, <(name)>, CSY_VARSCOPE( <.ro.> [, <assignScope>] ), <(originalName)>, [<class>()] [CSY_TYPE <type>] ) )

#command    VAR <(name1)> [, <(nameN)>] TO [<cls: CLASS>] [<(subordVar)>] [<ro: READONLY, RO>] [ASSIGN <assignScope>] ;
                => ;
                self:addMsgGroup( cmsVarDeleg(), { <(name1)> [, <(nameN)>] }, CSY_VARSCOPE( <.ro.> [, <assignScope>] ), nil, <(subordVar)>, <.cls.> )

#command    VAR <(name)> [IS <(targetName)>] TO [<cls: CLASS>] [<(subordVar)>] [<ro: READONLY, RO>] [ASSIGN <assignScope>] ;
                => ;
                self:addMsg( cmsVarDeleg():new( self, <(name)>, CSY_VARSCOPE( <.ro.> [, <assignScope>] ), <(targetName)>, <(subordVar)>, <.cls.> ) )

#command    VAR <name> [IS <tgtName>] IN <class> ;
                => ;
                self:addMIRedef( <(name)>, <(tgtName)>, <class>() )


/*
    CLASS VAR                   Declare class variable
    CLASS VAR...IS              Declare new name for existing class variable
    CLASS VAR...TO              Declare delegated class variable(s)
    CLASS VAR...[IS...] TO      Declare delegated class variable
*/

#xcommand   CLASS VAR <(name1)> [, <(nameN)>] [CLASS <class>] [TYPE <type>] [<ro: READONLY, RO, NOASSIGN>] [ASSIGN <assignScope>] [<sh: SHARED>] ;
                => ;
                metaClass:addVars( IF( <.sh.>, cmsShrClsVar(), cmsVariable() ), { <(name1)> [, <(nameN)>] }, CSY_VARSCOPE( <.ro.> [, <assignScope>] ), [<class>()] [CSY_TYPE <type>] )

#command    CLASS VAR <(name)> IS <(originalName)> [<ro: READONLY, RO>] [CLASS <class>] [TYPE <type>] [ASSIGN <assignScope>]  ;
                => ;
                metaClass:addMsg( cmsVarRedef():new( self, <(name)>, CSY_VARSCOPE( <.ro.> [, <assignScope>] ), <(originalName)>, [<class>()] [CSY_TYPE <type>] ) )

#command    CLASS VAR <(name1)> [, <(nameN)>] TO [<cls: CLASS>] [<(subordVar)>] [<ro: READONLY, RO>] [ASSIGN <assignScope>] ;
                => ;
                metaClass:addMsgGroup( cmsVarDeleg(), { <(name1)> [, <(nameN)>] }, CSY_VARSCOPE( <.ro.> [, <assignScope>] ), nil, <(subordVar)>, <.cls.> ) )

#command    CLASS VAR <(name)> [IS <(targetName)>] TO [<cls: CLASS>] [<(subordVar)>] [<ro: READONLY, RO>] [ASSIGN <assignScope>] ;
                => ;
                metaClass:addMsg( cmsVarDeleg():new( self, <(name)>, CSY_VARSCOPE( <.ro.> [, <assignScope>] ), <(targetName)>, <(subordVar)>, <.cls.> ) )

#command    CLASS VAR <name> [IS <tgtName>] IN <class> ;
                => ;
                metaClass:addMIRedef( <(name)>, <(tgtName)>, <class>() )


/*
    METHOD                      Declare method(s)
    METHOD...CONSTRUCTOR        Declare constructor method(s)
    CLASS METHOD                Declare class method(s)

    Note that the METHOD command used to begin the actual definition of a
    method (the method's code) is defined in ENDCLASS.CH.  METHOD is
    translated to DECL_METHOD in NEWCLASS.CH.
*/

#xcommand   DECL_METHOD <method1> [, <methodN>]                         ;
                =>                                                      ;
                self:addMethods( { { <"method1">, { || <method1>() } }  ;
                                [, { <"methodN">, { || <methodN>() } }] }, nScope )

#xcommand   METHOD <method1> [, <methodN>] <ct: CONSTRUCTOR, CTOR>  ;
                =>                                                  ;
                METHOD <method1> [, <methodN>]                      ;;
                CLASS MESSAGE <method1> [, <methodN>] IS altNew

#command    CLASS METHOD <method1> [, <methodN>]    ;
                =>                                  ;
                metaClass:addMethods( { { <"method1">, { || <method1>() } } ;
                                     [, { <"methodN">, { || <methodN>() } }] }, nScope )
/*
    MESSAGE...METHOD                Declare message and corresponding method
    MESSAGE...METHOD CONSTRUCTOR    Declare constructor message & method
    MESSAGE...IS                    Declare new name(s) for existing message
    MESSAGE...TO                    Declare delegated message(s)
    MESSAGE...IS...TO               Declare delegated message
*/

#command    MESSAGE <message> METHOD <method>   ;
                =>                              ;
                self:addMethods( { { <"message">, { || <method>() } } }, nScope )

#command    MESSAGE <message> METHOD <method> <ct: CONSTRUCTOR, CTOR>   ;
                =>                                                      ;
                MESSAGE <message> METHOD <method>                       ;;
                CLASS MESSAGE <message> IS altNew

#command    MESSAGE <(name1)> [, <(nameN)>] IS <(originalName)>     ;
                =>                                                  ;
                self:addMsgGroup( cmsRedef(), { <(name1)> [, <(nameN)>] }, nScope, <(originalName)> )

#command    MESSAGE <(name1)> [, <(nameN)>] TO [<cls: CLASS>] [<(subordVar)>]  ;
                =>                                                      ;
                self:addMsgGroup( cmsDeleg(), { <(name1)> [, <(nameN)>] }, nScope, nil, <(subordVar)>, <.cls.> )

#command    MESSAGE <(name)> [IS <(targetName)>] TO [<cls: CLASS>] [<(subordVar)>] ;
                =>                                                          ;
                self:addMsg( cmsDeleg():new( self, <(name)>, nScope, <(targetName)>, <(subordVar)>, <.cls.> ) )

#command    MESSAGE <name> [IS <tgtName>] IN <class> ;
                => ;
                self:addMIRedef( <(name)>, <(tgtName)>, <class>() )


/*
    CLASS MESSAGE...METHOD          Declare class message and matching method
    CLASS MESSAGE...IS              Declare new name(s) for class message
    CLASS MESSAGE...TO              Declare delegated class message(s)
    CLASS MESSAGE...IS...TO         Declare delegated class message
*/

#xcommand   CLASS MESSAGE <message> METHOD <method> ;
                =>                                  ;
                metaClass:addMethods( { { <"message">, { || <method>() } } }, nScope )

#xcommand   CLASS MESSAGE <(name1)> [, <(nameN)>] IS <(originalName)>  ;
                =>                                      ;
                metaClass:addMsgGroup( cmsRedef(), { <(name1)> [, <(nameN)>] }, nScope, <(originalName)> )

#xcommand   CLASS MESSAGE <(name1)> [, <(nameN)>] TO [<cls: CLASS>] [<(subordVar)>] ;
                =>                                                                  ;
                metaClass:addMsgGroup( cmsDeleg(), { <(name1)> [, <(nameN)>] }, nScope, nil, <(subordVar)>, <.cls.> )

#xcommand   CLASS MESSAGE <(name)> [IS <(targetName)>] TO [<cls: CLASS>] [<(subordVar)>]    ;
                =>                                                                          ;
                metaClass:addMsg( cmsDeleg():new( self, <(name)>, nScope, <(targetName)>, <(subordVar)>, <.cls.> ) )

#command    CLASS MESSAGE <name> [IS <tgtName>] IN <class> ;
                => ;
                metaClass:addMIRedef( <(name)>, <(tgtName)>, <class>() )

// Handle results of unnecessary declaration: METHOD <new | init> CTOR
#xcommand   CLASS MESSAGE <name: new, init> IS altNew    =>


/*
    some valid forms of super-call METHOD command:

        METHOD name, ()
        METHOD name(), ()
        METHOD name(...), ()
        METHOD name(...), (...)
        METHOD name(...), superName(...)
        METHOD name(...), superName()
*/

#xtranslate _CSY_CALLSUPER( <dfltName>([<ignore,...>])[()], [<name>]([<params,...>]) ) ;
                => ;
                qself():super:CSY_OPT([<name>,] <dfltName>)(<params>)

#command    METHOD [<type: PROCEDURE, FUNCTION>] <spec>, <superSpec>    ;
                =>                                                      ;
                __cyMethodType CSY_OPT([<type>,] FUNCTION) <spec>       ;;
                local self := (_CSY_CALLSUPER( <spec>(), <superSpec> ), qself())

#command    METHOD <type: PROCEDURE, FUNCTION> <name>   ;
                =>                                      ;
                __cyMethodType <type> <name>            ;;
                local self := qself()

#define __cyMethodType

/*
    self is a reserved word inside Class(y) methods.
    :: is shorthand for message sends to self.
*/

#translate  ::  =>  self:

#translate  @:<methodName>([<param1>] [, <paramN>]) ;
                =>                                  ;
                <methodName>(_cyPshSelf(<param1>) [, <paramN>])


// eof classy2.ch
