@ echo off
if not exist c68kasfx.exe goto wrongdrive
if "%1" == "" goto nodrive
if "%2" == "" goto nodir
if "%2" == "\" goto noroot

echo	+
echo	Installation script for CrossCode C Assembler.
echo	+
echo	Be sure you are on the drive containing the disk that needs
echo	to be installed.  If not, press Ctrl-C to abort batch script.
echo	+
echo	Installing into %1%2
echo	+
pause

if "0" == "0" goto zip
if not exist %1%2\cmd\freeform.ini  goto zip
echo	+
echo	%1%2\cmd\freeform.ini already exists.
echo	Saving it as freefor0.ini
echo	+
copy %1%2\cmd\freeform.ini %1%2\cmd\freefor0.ini

:zip
c68kasfx.exe -o -d %1%2
if errorlevel 1 goto invalid
goto normexit

rem ***************************************************************************
rem *** Exits
rem ***************************************************************************

:nodrive
    echo +
    echo INSTALLATION ERROR: please specify target drive as parameter 1
    echo +
    goto usage

:nodir
    echo +
    echo INSTALLATION ERROR: please specify target directory as parameter 2
    echo +
    goto usage

:invalid
    echo INSTALLATION FAILED
    goto end

:wrongdrive
    echo	+
    echo	INSTALLATION ERROR: Current drive invalid
    echo	+
    goto usage

:noroot
    echo	+
    echo	INSTALLATION ERROR: The target directory cannot be the root directory
    echo	+
    goto usage

:usage
    echo	+
    echo	Installation script for CrossCode C Assembler.
    echo	+
    echo	This script installs the contents of the disk under the
    echo	specified directory.  It should be invoked as follows:
    echo	+
    echo	  install  target_drive  target_directory
    echo	+
    echo	The target directory CANNOT be the root directory (\). The 
    echo	current drive MUST be the drive containing the disk that
    echo	is to be installed.
    echo	+
    echo	For example, to install the contents of the disk under
    echo	c:\xcode, the script should be invoked as
    echo	+
    echo	  install  c:  \xcode
    echo	+
    goto end

:normexit
    echo +
    echo INSTALLATION COMPLETE
    echo Installed files under %1%2
    echo Please make sure that %1%2\cmd is present in your PATH
    echo +

:end
