/* rexx - Remove.CMD removes previous beta from the system       */
/* by   Greg Czaja Feb. 28, 1993       1.0 b3                    */
/* and  Development Technologies, Inc.                           */
/* destroys the object, deregisters the class, cleans up the INI */
/* DMAN.DLL, DMAN.INF, DMANHELP.HLP are searched on all disks    */
/* DeskMan.DLL, DeskMan.INF, DManHelp.HLP for drops after 1.0 b1 */
/* and deleted after user's confirmation                         */


Parse Arg drives_parm .   /* a drive letter may be passed as parameter */
If drives_parm<>'' & Right(drives_parm,1) <> ':'
   Then drives_parm=drives_parm||':';

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;           
     /* code below removes beta drops installed before 1.0 b1 */
     rc=SysDestroyObject("<DMAN1>");
     rc=SysDeregisterObjectClass('DMan');
     Call SysIni 'USER', 'DMan', 'DELETE:';
                             /* look for DeskMan files now... */
     Call FindFile 'DMan.DLL';
     Call FindFile 'DMan.INF';
     Call FindFile 'DManHelp.HLP';

     /* code below removes beta drops installed after  1.0 b1 */
     rc=SysDestroyObject("<DeskMan1>");
     rc=SysDestroyObject("<DESKMAN_INF>");
     rc=SysDeregisterObjectClass('DMan');
     Call SysIni 'USER', 'DeskMan', 'DELETE:';
                             /* look for DeskMan files now... */
     Call FindFile 'DeskMan.DLL';
     Call FindFile 'DeskMan.INF';
     Call FindFile 'DeskMan.HLP';

Exit;
          /* looks for specified file and erases it upon user's confirmation */
FindFile: Procedure Expose drives_parm;
Arg file .
     other_dirs='';
    If drives_parm=''
       Then drives=SysDriveMap('C:','LOCAL');
       Else drives=drives_parm;
    Do While drives<>'';
       Parse Var drives this_drive drives;
       drive_info=SysDriveInfo(this_drive);
       Parse Var drive_info dr free .
       If free=0 Then Iterate;     /* probably CD-ROM - don't touch ! */
       Say 'DeskMan/2 - looking for:' file 'on drive:' this_drive;
       Call SysFileTree this_drive||'\'||file, 'files.', 'sfo';
       Do i=1 to files.0;
          If Pos(file, Translate(files.i)) > 0   /* found it ! */
             Then Do;
               other_dirs=files.i;
               Say 'DeskMan/2 was previously installed on this system and 'file' was in:'
               Say '          'other_dirs;
               Say 'Do you want the 'file' to be removed? Enter Y(es) or N(o) now...';
               reply=Translate(SysGetKey());
               Say '';
               If Left(reply,1) = 'Y'
                  Then
                    '@ERASE 'other_dirs;
               End;
       End;
     End;
Return;
