/* REXX OS/2 - PerfSO.CMD  perform a Save object     Save function  */
/* by  Greg Czaja                                                   */
/* and Development Technologies, Inc.   ver. 1.10   August 15, 1993 */
/*                                                                  */
/* Note: the DRC file specified will be used to save the object(s). */
/*       REXX generation and Save options take place depending on   */
/*       current DeskMan/2 settings - can be set prior to runtime.  */
/*       The folder can be either a folder title, object ID or      */
/*       a physical path.                                           */
/*       The folder and object names should be surrounded by "      */
/*       if containing blanks.                                      */
/*       The format is:                                             */
/*       PerformSaveObject=x:\path\file.drc,name,FolderName; 
         PerformSaveObject=x:\path\file.drc,ALL,FolderName;
         FolderName can be:   . folder title
                              . object ID
                              . fully qualified path
   Note: To save the results of using other DeskMan/2 setup strings,
         PerformSaveSettings=YES;
         is used to save the current (after the SysSetObjectData)
         DeskMan/2 settings! If PerformSaveSettings is not used, the
         settings are changed but not saved, so the user's settings
         (prior to SysSetObjectData) will be restored on the next
         system boot.
 */

/* Execute as: PERFSO x:\deskman\test.drc Name Folder               */

Parse Arg args;
If Left(args,1) = '"'
   Then Parse Var args '"'DRCfile'"' args;
   Else Parse Var args    DRCfile    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' .;
   Else Parse Var args    folder    .;


If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;
If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'GENERATEREXX=NO;'||,
                    'PerformSaveObject='DRCfile','object','folder';'||,
                    'PerformSaveSettings=YES;');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Save object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Save object initiated successfully!';
Exit 0;                
