/* REXX OS/2 - PrfrmSD.CMD  perform a Save Desktop function         */
/* by  Greg Czaja                                                   */
/* and Development Technologies, Inc.   ver. 1.10   August 15, 1993 */
/*                                                                  */
/* Note: the DRC file specified will be used to save the objects    */
/*       NO REXX generation is performed.                           */
/*       The current Update/Replace option for the DRC file is used */
/*       and can be specified in the setup string on the Perform    */
/*       request or in a previous SysSetObjectData statement.       */
/*       The icons / icon directory: ditto.                         */
/*       Save data files / data files directory: ditto.             */
/*       The format is:                                             */
/*       PerformSaveDesktop=x:\path\file.drc;                       */

/* Execute as: PERFSD x:\deskman\test.drc                           */

Arg DRCfile . ;  /* accept the DRC file name as parameter           */

If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

If Right(DRCfile, 1) <> ';'
   Then DRCfile=DRCfile||';';     /* remember! SEMICOLON */

rc=SysSetObjectData('<DeskMan1>', 'PerformSaveDesktop='DRCfile);
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Save Desktop!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Save desktop initiated successfully!';
Exit 0;                

/* ----------------------------------------------------------------*/
