/* REXX OS/2 - PerfRS.CMD  perform a System Settings Restore function  */
/* by  Greg Czaja                                                      */
/* and Development Technologies, Inc.   ver. 1.10   August 15, 1993 */
/*                                                                     */
/* Note: the IRC file specified will be used to save the settings.     */
/*       The format is:                                                */
/*       PerformRestoreSystemSettings=x:\path\fileI.drc;               */

/* Execute as: PERFRS x:\deskman\deskman.IRC                           */

Arg IRCfile . ;  /* accept the IRC file name as parameter           */

If IRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the IRC file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

If Right(IRCfile, 1) <> ';'
   Then IRCfile=IRCfile||';';     /* remember! SEMICOLON */

rc=SysSetObjectData('<DeskMan1>', 'PerformRestoreSystemSettings='IRCfile);
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Restore System Settings!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Restore System Settings initiated successfully!';
Exit 0;                

/* ----------------------------------------------------------------*/
