/* REXX OS/2 - PerfRO.CMD  perform a Restore object function        */
/* by  Greg Czaja                                                   */
/* and Development Technologies, Inc.   ver. 1.10   August 15, 1993 */
/*                                                                  */
/* Note: DeskMan/2 settings - can be set prior to execution.        */
/*       The folder can be either a folder title, object ID or      */
/*       a physical path.                                           */
/*       The folder and object names should be surrounded by "      */
/*       if containing blanks.                                      */
/*       The format is:                                             */
/*     . single object in a folder:
         PerformRestoreObject=x:\path\file.drc,objectName,FolderName,Option;
       . all objects (including subfolders) in a folder:
         PerformRestoreObject=x:\path\file.drc,ALL,FolderName,Option;
       . all objects from the DRC file specified:
         PerformRestoreObject=x:\path\file.drc,ALL,ALL,Option;

         FolderName can be:   . folder title
                              . folder's object ID
 */

/* Execute as: PERFRO x:\deskman\test.drc Name Folder Option        */

Parse Arg args;
If Left(args,1) = '"'
   Then Parse Var args '"'DRCfile'"' args;
   Else Parse Var args    DRCfile    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' option;
   Else Parse Var args    folder    option;


If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;
If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;
If Option  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the Restore option is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'PerformRestoreObject='DRCfile','object','folder','option';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Restore object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Restore object initiated successfully!';
Exit 0;                
