/* REXX OS/2 - PerfRD.CMD  perform a Restore Desktop function       */
/* by  Greg Czaja                                                   */
/* and Development Technologies, Inc.   ver. 1.10   August 15, 1993 */
/*                                                                  */
/* Note: the DRC file specified will be used to restore the desktop */
/*       objects.  Presence of a Desktop object is required!        */
/*       The restore option may be specified on the Perform         */
/*       statement (UPDATE, REPLACE or SKIP).  If none is           */
/*       specified, the current default will be used.               */
/*       The format is:                                             */
/*       PerformRestoreDesktop=x:\path\file.drc,OPTION;             */
/*       OPTION can be: SKIP, UPDATE, REPLACE                       */

/* Execute as: PERFRD x:\deskman\test.drc SKIP                      */

              /* accept the DRC file name and option as parameters  */
Arg DRCfile option ; 
option=Translate(option);                              /* upperCASE */

If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

If Right(option, 1) <> ';'
   Then semicolon=';';                        /* remember! SEMICOLON */
   Else semicolon='';

If option = ''
   Then
     rc=SysSetObjectData('<DeskMan1>',,
        'PerformRestoreDesktop='DRCfile||semicolon);
   Else
     rc=SysSetObjectData('<DeskMan1>',,
        'PerformRestoreDesktop='DRCfile||','||option||semicolon);

If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Restore Desktop!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Restore desktop initiated successfully!';
Exit 0;                

/* ----------------------------------------------------------------*/
