/* REXX OS/2 - PerfDO.CMD  perform a Destroy object function        */
/* by  Greg Czaja                                                   */
/* and Development Technologies, Inc.   ver. 1.10   August 15, 1993 */
/*                                                                  */
/*       The folder and object names should be surrounded by "      */
/*       if containing blanks.                                      */
/*       The format is:                                             */
/*       PerformDestroyObject=name,FolderName;
         PerformDestroyObject=ALL,FolderName;
         FolderName can be:   . folder title
                              . object ID
                              . fully qualified path
         If name == ALL, all objects located in the specified folder,
         including the folder itself, will be destroyed.
 */

/* Execute as: PERFDO Name Folder                                   */

Parse Arg args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' .;
   Else Parse Var args    folder    .;

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'PerformDestroyObject='object','folder';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Destroy object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Destroy object initiated successfully!';
Exit 0;                
