/* REXX OS/2 - DeskManR.CMD installs DeskMan/2 and sets all Settings   */
/* by  Greg Czaja                                                      */
/* and Development Technologies, Inc.   ver. 1.10    August 15, 1993   */

Arg CFGfile . ;  /* accept the CFG file name as parameter              */

/* Provided sample file, DESKMAN.CFG, MUST BE CONFIGURED prior to use! */

If CFGfile = ''
   Then Do;
     Say 'DeskMan/2 INSTALL: the CFG file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

ini.='';

If \ ParseCFG(CFGfile)
   Then Exit 99;               /* error while parsing - exit with error */

required='SOURCE TARGETDLL TARGETHLP TARGETINF LOCDESKMAN LOCINF SYSDATA IGNOREINI',
         'IconPath DataPath InFile IRCFileName LogFile OutFile REXXFile REXXIFileName',
         'REGISTER CUSTOMER HELP GUIDE';
compared=required;
error=0;
Do i=1 to Words(required);
   word=Word(required, i);
   x= Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
          Select            /* certain values may be omitted       */
            When word='TARGETHLP'
              Then Do;
                If ini.HELP <> 'NO'      /* need TARGETHLP         */
                   Then Do;
                     error=1;
                     Say 'DeskMan/2 INSTALL: TARGETHLP value is required.';
                     Iterate;
                     End;
                End;
            When word='TARGETINF'
              Then Do;
                If ini.GUIDE <> 'NO'
                   Then Do;
                     error=1;
                     Say 'DeskMan/2 INSTALL: TARGETINF value is required.';
                     Iterate;
                     End;
                End;
            When word='LOCINF'
              Then Do;
                If ini.GUIDE <> 'NO'
                   Then Do;
                     error=1;
                     Say 'DeskMan/2 INSTALL: LOCINF value is required.';
                     Iterate;
                     End;
                End;
            Otherwise
                error=1;
                Say 'DeskMan/2 INSTALL:' word 'value is required.';
                Iterate;
          End;
        End;
   compared=DelWord(compared, WordPos(word, compared),  1);
                                         /* value checked - not needed anymore */
End;

If compared <> ''
   Then Do;
     error=1;
     Say 'DeskMan/2 INSTALL: the following keyword values are not present in the';
     Say 'CFG file:';
     Say compared;
     End;

If error Then Exit 99               /* errors found - exit                   */

                   /* we accept RC <> 0 since the class may be not there yet */
rc=SysDestroyObject("<DeskMan1>");
rc=SysDeregisterObjectClass('DMan');    

Say  'DeskMan/2 INSTALL: installing from:' ini.SOURCE 'into' ini.TARGET 'directory.';

If Directory() <> ini.TARGETDLL    /* Do not erase installation files! */
   Then Do;
     '@ERASE "'ini.TARGETDLL'\DESKMAN.DLL" 2>NUL';
     '@COPY "'ini.SOURCE'\DESKMAN.DLL"' ini.TARGETDLL;
     End;
   Else rc=0;
If rc <> 0                /* copy failed                           */
   Then Do;
     Say  "DeskMan/2 INSTALL: could not replace the DLL, rc="rc". A system re-boot may be required!";
     Say  "Did you remember to DELETE DeskMan/2 object from the desktop?";
     Exit 99;
     End;

rc=SysRegisterObjectClass('DMan',ini.TARGETDLL'\DESKMAN.DLL');
If rc <> 1                /* copy failed                           */
   Then Do;
     Say  "DeskMan/2 INSTALL: could not register the DeskMan/2 object class.";
     Exit 99;
     End;

oldIconPath=SysIni('USER', 'DeskMan', 'IconPath');
If Right(ini.IconPath, 1) <> '\'
   Then ini.IconPath=ini.IconPath'\';
If Left(oldIconPath, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newIconPath=ini.IconPath||'00'x;
   Else newIconPath=oldIconPath;
rc=SysIni('USER', 'DeskMan', 'IconPath', newIconPath);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for IconPath.';
     Exit 99;
     End;
oldDataPath=SysIni('USER', 'DeskMan', 'DataPath');
If Right(ini.DataPath, 1) <> '\'
   Then ini.DataPath=ini.DataPath'\';
If Left(oldDataPath, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newDataPath=ini.DataPath||'00'x;
   Else newDataPath=oldDataPath;
rc=SysIni('USER', 'DeskMan', 'DataPath', newDataPath);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for DataPath.';
     Exit 99;
     End;
oldInFile=SysIni('USER', 'DeskMan', 'InFile');
If Left(oldInFile, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newInFile=ini.InFile||'00'x;
   Else newInFile=oldInFile;
rc=SysIni('USER', 'DeskMan', 'InFile', newInFile);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for InFile.';
     Exit 99;
     End;
oldIRCFileName=SysIni('USER', 'DeskMan', 'IRCFileName');
If Left(oldIRCFileName, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newIRCFileName=ini.IRCFileName||'00'x;
   Else newIRCFileName=oldIRCFileName;
rc=SysIni('USER', 'DeskMan', 'IRCFileName', newIRCFileName);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for IRCFileName.';
     Exit 99;
     End;
oldLogFile=SysIni('USER', 'DeskMan', 'LogFile');
If Left(oldLogFile, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newLogFile=ini.LogFile||'00'x;
   Else newLogFile=oldLogFile;
rc=SysIni('USER', 'DeskMan', 'LogFile', newLogFile);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for LogFile.';
     Exit 99;
     End;
oldOutFile=SysIni('USER', 'DeskMan', 'OutFile');
If Left(oldOutFile, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newOutFile=ini.OutFile||'00'x;
   Else newOutFile=oldOutFile;
rc=SysIni('USER', 'DeskMan', 'OutFile', newOutFile);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for OutFile.';
     Exit 99;
     End;
oldREXXFile=SysIni('USER', 'DeskMan', 'REXXFile');
If Left(oldREXXFile, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newREXXFile=ini.REXXFile||'00'x;
   Else newREXXFile=oldREXXFile;
rc=SysIni('USER', 'DeskMan', 'REXXFile', newREXXFile);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for REXXFile.';
     Exit 99;
     End;
oldREXXIFileName=SysIni('USER', 'DeskMan', 'REXXIFileName');
If Left(oldREXXIFileName, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newREXXIFileName=ini.REXXIFileName||'00'x;
   Else newREXXIFileName=oldREXXIFileName;
rc=SysIni('USER', 'DeskMan', 'REXXIFileName', newREXXIFileName);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for REXXIFileName.';
     Exit 99;
     End;
oldSysData=SysIni('USER', 'DeskMan', 'SysData');
If Left(oldSysData, 5)='ERROR' | ini.IGNOREINI='YES'
   Then newSysData=ini.SysData||'00'x;
   Else newSysData=oldSysData;
rc=SysIni('USER', 'DeskMan', 'SysData', newSysData);
If rc <> ''
   Then Do;
     Say 'DeskMan/2 INSTALL: error setting the value for SysData.';
     Exit 99;
     End;

others='INSTALL=YES;REGISTER='ini.REGISTER';CUSTOMER='ini.CUSTOMER';';

rc=SysCreateObject('DMan','DeskMan/2', ini.LOCDESKMAN, ,
   'ICONFILE='ini.SOURCE'\DESKMAN2.ICO;OBJECTID=<DeskMan1>;NOCOPY=YES;INSTALL=YES;'||,
    others,,
   'ReplaceIfExists');
If rc <> 1                 /* registered OK ?                */
   Then Do;
     Say  "DeskMan/2 INSTALL: could not create DeskMan/2 object.";
     Exit 99;
     End;

If ini.HELP = 'YES'
   Then Do;
     If Directory() <> ini.TARGETHLP    /* Do not erase installation files! */
        Then Do;
          '@ERASE "'ini.TARGETHLP'\DESKMAN.HLP" 2>NUL';
          '@COPY "'ini.SOURCE'\DESKMAN.HLP"' ini.TARGETHLP;
          End;
        Else rc=0;
     If rc <> 0                /* copy failed                           */
        Then Do;
          Say  "DeskMan/2 INSTALL: could not replace the HLP, rc="rc".";
          Exit 99;
          End;
     End;
If ini.GUIDE = 'YES'
   Then Do;
     If Directory() <> ini.TARGETINF    /* Do not erase installation files! */
        Then Do;
          '@ERASE "'ini.TARGETINF'\DESKMAN.INF" 2>NUL';
          '@COPY "'ini.SOURCE'\DESKMAN.INF"' ini.TARGETINF;
          End;
        Else rc=0;
     If rc <> 0                /* copy failed                           */
        Then Do;
          Say  "DeskMan/2 INSTALL: could not replace the INF, rc="rc".";
          Exit 99;
          End;
     rc=SysCreateObject('WPProgram',"DeskMan/2"||'0A'x||"User's Guide", ini.LOCINF,,
        'EXENAME=VIEW.EXE;PARAMETERS=DESKMAN.INF;OBJECTID=<DESKMAN_INF>;','Update');
     End;

Settings='GENERATEDRC DRCSAVE DRCSAVEREPLACE DRCSAVEUPDATE SAVEDRCPROMPT',
         'RESOLVEFOLDERS GENERATEREXX REXXSAVE REXXSAVEREPLACE REXXSAVEUPDATE',
         'REXXSAVEPROMPT SAVEICONS ICONDIRECTORY SAVEDATAFILES DATADIRECTORY',
         'ASSIGNOBJECTIDORIGINAL ASSIGNOBJECTIDALL NOWARNINGS',
         'NOWARNINGSDOSWINOS2 DRCRESTORE INIRCRESTORE RESTOREREPLACE',
         'RESTORESKIP RESTOREUPDATE RESTOREPROMPT RESTORESEARCH',
         'USEMINIICONS DEFAULTVIEW DEBUG USEPMPRINTF LOGFILE',
         'SAVESYSTEMSETTINGS SYSTEMSETTINGSREXX SAVECONTROLPANEL SAVECOLORS',
         'DRCSYSTEM REXXSYSTEM';
         
setup='';
error=0;
Do i=1 to Words(Settings);
   word=Word(Settings, i);
   x= Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
        Say 'DeskMan/2 INSTALL:' word 'value will be left UNCHANGED!';
        Iterate;
        End;
   If Right(ini.word,1) <> ';'
      Then ini.word=ini.word||';';
   setup=setup||word'='ini.word;
End;

If setup <> ''             /* change the DeskMan/2 Settings        */
   Then Do;
     rc=SysSetObjectData('<DeskMan1>', setup);
     If rc <> 1           
        Then Do;
          Say  "DeskMan/2 INSTALL: error changing Settings for DeskMan/2 object.";
          Exit 99;
          End;
     End;

Functions='AllowOpenSettings AllowOpenDeskMan AllowOpenStandard AllowOpenDebug',
          'AllowMove AllowShadow AllowDelete AllowSaveDesktop',
          'AllowRestoreDesktop AllowSystemSave AllowSystemRestore AllowSaveObjects',
          'AllowSpecials AllowDestroy AllowQueryObject AllowAssignID',
          'AllowOpenObject AllowAssignIcon AllowChangeStyle',
          'AllowOpenDRC AllowSaveDRC',
          'AllowSort AllowView AllowSelect AllowInclude AllowFind AllowArrange',
          'AllowRecreateObject AllowRecreateFolder AllowSelectFolder',
          'AllowFindFolder AllowChangeSetup AllowMapDrives AllowRemove',
          'AllowGenerateREXX AllowDragNDrop AllowCancel';
setup='';
error=0;
Do i=1 to Words(Functions);
   word=Word(Functions, i);
   x= Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
        Say 'DeskMan/2 INSTALL:' word 'value will be UNCHANGED!';
        Iterate;
        End;
   If Right(ini.word,1) <> ';'
      Then ini.word=ini.word||';';
   setup=setup||word'='ini.word;
End;

If setup <> ''             /* change the DeskMan/2 Settings        */
   Then Do;
     rc=SysSetObjectData('<DeskMan1>', setup);
     If rc <> 1           
        Then Do;
          Say  "DeskMan/2 INSTALL: error setting functions for DeskMan/2 object.";
          Exit 99;
          End;
     End;

Say 'DeskMan/2 INSTALL: DeskMan/2 was installed successfully!';
Exit 0;                   /* successfull install Exit!             */

/* ----------------------------------------------------------------*/
ParseCFG: Procedure Expose ini.

CFGfile=Arg(1);           /* the CFG file name */

linenum=0;
Do While Lines(CFGfile);
   line=Linein(CFGfile);
   linenum=linenum + 1;
   If Left(line,1) = '*'
      Then Iterate;       /* skip comment lines */

   Parse Var line keyword '=' value;
   If ini.keyword <> ''
      Then Do;
        Say 'DeskMan/2 INSTALL: duplicate keyword in line' linenum 'ignored.';
        Iterate;
        End;
   If value = ''
      Then Do;
        Say 'DeskMan/ INSTALL: invalid value for the' keyword 'keyword in line' linenum;
        Say 'DeskMan/ INSTALL: install error.';
        Return 0;
        End;
   ini.keyword=value;
End;
Call Stream CFGfile, 'C', 'CLOSE';

Return 1;
