/******************************************************************************\
|                                                                              |
|   "Champion" Integrated Office Automation Program                            |
|                                                                              |
|   Do not remove this Copyright notice.                                       |
|   Copyright (c) 1992, 1993 Microburst, Inc. All rights reserved.             |
|   [Unpublished Work] CONFIDENTIAL INFORMATION                                |
|                                                                              |
\******************************************************************************/
/**
*
* Constants
*
**/
#define K_DPR  57.29577951308232   // degrees per radian
#define K_E    2.718281828459045   // base of natural logs
#define K_PI   3.141592653589794   // PI
#define K_RPD  0.0174532925199433   // radians per degree
/**
*
* Special values and macros to reference them
*
*/
extern ushort NAN_Error[4];   // NAN value for a calculation error
#define NAN_ERROR (*((double *)(NAN_Error)))
/**
*
* The following symbols are used for the operator codes in the parsed form
* of an algebraic expression.
*
**/
#define O_END       0      // end of expression             x00
#define O_ADD       1      // add                           x01
#define O_SUB       2      // subtract                      x02
#define O_MUL       3      // multiply                      x03
#define O_DIV       4      // divide                        x04
#define O_MINUS     5      // unary minus                   x05
#define O_PWR       6      // power                         x06
#define O_EQ        7      // equal to                      x07
#define O_NE        8      // not equal to                  x08
#define O_LT        9      // less than                     x09
#define O_GT       10      // greater than                  x0A
#define O_LE       11      // less than or equal to         x0B
#define O_GE       12      // greater than or equal to      x0C
#define O_LP       13      // left parenthesis              x0D
#define O_RP       14      // right parenthesis             x0E
#define O_COMMA    15      // comma separator               x0F
#define O_BLANK    16      // blank separator               x10
#define O_PCT      17      // percent                       x11
#define O_FUNC     18      // function                      x12

#define O_TEXT     19      // text                          x13
#define O_SHORT    20      // short integer (16 bits)       x14
#define O_LONG     21      // long integer (32 bits)        x15
#define O_DOUBLE   22      // double (64 bits)              x16

#define O_CELL     23      // cell reference                x17
#define O_CELLERR  24      // cell ref error                x18

#define O_CELLS    25      // cell range reference          x19
#define O_CELLSERR 26      // pending range ref error       x1A

#define O_SKIP     27      // skip within expression        x1B
#define O_SKIPZ    28      // skip if previous term is 0    x1C
/**
*
* The following structure is used for terms (operands) pushed onto the
* operand stack during expression evaluation.  See EvalExp.
*
**/
typedef _Packed struct _EVALTERM
{
   union            // operand
   {
      double d;
      SSPOINT p;
      SSRECT r;
      char t[255];
   } x;
   byte type;         // operand type
} EVALTERM;
/**
*
* The following structure contains the evaluation stack and other information
* needed during expression evaluation.
*
**/
#define NTERMS 16         // evaluation stack size
typedef _Packed struct _EVALINFO
{
   PSS ss;            // spreadsheet parameters
   SSPOINT base;         // base cell coordinates
   int tx;            // stack index
   EVALTERM ts[NTERMS];      // operand stack
} EVALINFO;
/**
*
* The following structure is used for terms (operands) pushed onto the
* operand stack during unparsing.  See TextFromExp.
*
**/
typedef _Packed struct _TEXTTERM
{
   int size;         // text size
   char text[254];         // text
} TEXTTERM;
/**
*
* The following structure provides the parser and unparser with information
* about functions.
*
**/
typedef _Packed struct _FUNCDEF
{
   byte code;         // function code
   byte type;         // function type
   int argc;         // number of args (-1 for variable)
   char *name;         // function name
   char *args;         // argument prototypes
} FUNCDEF;
typedef FUNCDEF *PFUNCDEF;
/*
*
* Definitions for FUNCDEF.type
*
*/
#define FT_Text      1      // text functions
#define FT_Logic     2      // logic functions
#define FT_Date      3      // date functions
#define FT_Time      4      // time functions
#define FT_Stat      5      // statistical functions
#define FT_Table     6      // table functions
#define FT_Trig      7      // trigonometric functions
#define FT_Finance   8      // financial functions
/*
*
* Definitions for FUNCDEF.code using Excel numbering scheme except for the
* following functions, which have no Excel equivalents:
*
*   FC_Avg      (using WINDOWS)
*   FC_Degrees    (using FWRITE)
*   FC_Radians    (using FWRITELN)
*   FC_String     (using DOLLAR)
*
* Several functions have been added to the Excel repertoire to facilitate
* importing from 1-2-3 and similar spreadsheets.  These are:
*
*   FC_HLook   (using INITIATE)
*   FC_VLook   (using TERMINATE)
*
*
*/
#define FC_Acos      0x63      // acos(value)
#define FC_Asin      0x62      // asin(value)
#define FC_And       0x24      // and(logicals)
#define FC_Atan      0x12      // atan(value)
#define FC_Average   0x05      // average(values)
#define FC_Avg       0x5B      // avg(values)
#define FC_Cos       0x10      // cos(value)
#define FC_Count     0x00      // count(values)
#define FC_Date      0x41      // date(year,month,day)
#define FC_DateValue 0x8C      // datevalue(text)
#define FC_Day       0x43      // day(date)
#define FC_Degrees   0x8A      // degrees(value)
#define FC_DDB       0x90      // ddb(cost,salvage,life,period)
#define FC_False     0x23      // false()
#define FC_Find      0x7C      // find(patt,text,index)
#define FC_Fixed     0x0E      // fixed(value,decimals)
#define FC_FV        0x39      // fv(rate,periods,payment,type)
#define FC_HLook     0xAF      // hlook(value,table,index)
#define FC_HLookup   0x65      // hlookup(value,table,index)
#define FC_Hour      0x47      // hour(time)
#define FC_If        0x01      // if(test,true,false)
#define FC_IRR       0x3E      // irr(values[,guess])
#define FC_Left      0x73      // left(text,n)
#define FC_Len       0x20      // len(text)
#define FC_Max       0x07      // max(values)
#define FC_Mid       0x1F      // mid(text,start,n)
#define FC_Min       0x06      // min(values)
#define FC_Minute    0x48      // minute(time)
#define FC_Month     0x44      // month(date)
#define FC_NA        0x0A      // not available
#define FC_Not       0x26      // not(logical)
#define FC_Now       0x4A      // now()
#define FC_NPV       0x0B      // npv(rate,values)
#define FC_Or        0x25      // or(logicals)
#define FC_PI        0x13      // PI
#define FC_Pmt       0x3B      // pmt(rate,periods,pv,[fv,type])
#define FC_Radians   0x89      // radians(value)
#define FC_Rept      0x1E      // rept(text,n)
#define FC_Search    0x52      // search(patt,text,index)
#define FC_Second    0x49      // second(time)
#define FC_Sin       0x0F      // sin(value)
#define FC_Sqrt      0x14      // sqrt(value)
#define FC_Stdev     0x0C      // stdev(values)
#define FC_Stdevp    0xC1      // stdevp(values)
#define FC_String    0x0D      // string(value,decimals)
#define FC_Sum       0x04      // sum(values)
#define FC_Tan       0x11      // tan(value)
#define FC_Time      0x42      // time(hour,minute,second)
#define FC_TimeValue 0x8D      // timevalue(text)
#define FC_Trim      0x76      // trim(text)
#define FC_True      0x22      // true()
#define FC_Upper     0x71      // upper(text)
#define FC_Var       0x2E      // var(values)
#define FC_Varp      0xC2      // varp(values)
#define FC_VLook     0xB3      // vlook(value,table,index)
#define FC_VLookup   0x66      // vlookup(value,table,index)
#define FC_Weekday   0x46      // weekday(date)
#define FC_Year      0x45      // year(date)
/**
*
* Function declarations
*
**/
PFUNCDEF FindFuncByCode(byte code);
PFUNCDEF FindFuncByName(char *name);
void InsertFuncProto(PSS ss,PFUNCDEF p);


