#ifndef TOOLPAL_H
#define TOOLPAL_H
//=======================================================================
//
//     File:			ToolPal.h
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//=======================================================================

#ifndef BRVIEW_H
#include <BRView.h>
#endif

class BR_COrderedCollection;
struct cDrawState;
class cPaintTool;

//========================================================================================
//	class cToolPalette
//========================================================================================

class cToolPalette : public BR_CView
{
public:
	enum 
	{
		ToolWidth		= 35,
		ToolHeight		= 35,
		NumberOfCols	= 2,
		LineWidth		= 3
	};
	
					cToolPalette(BR_CView *, BR_CBureaucrat *, cDrawState *);
	virtual			~cToolPalette();	 //Override

	//	Overriden methods
	virtual void	Draw(BR_CCanvas &canvas, const BR_CRectangle &area); //Override
	virtual void	DoClick(const BR_CPoint& ptMouse, KeyModifiers keys);
	
protected:
	void			AddTool(cPaintTool *tool);
	BR_CRectangle	GetToolRectangle(int ToolNumber);
	
	//	Draw the tool selected or unselected at the location specified
	void			DrawSelected(int ToolNumber, BR_CRectangle &Location);
	void			DrawUnselected(int ToolNumber, BR_CRectangle &Location);
	void			DrawRect(BR_CRectangle &r, BR_CColor::RGBValue anRGBValue);

private:
	int														fCurrentToolNumber;
	cDrawState												*fDrawState;
	BC_TUnboundedCollection<cPaintTool *, BC_CUnmanaged>	*fToolCollection;
	BC_TUnboundedCollection<BR_CBitmap *, BC_CUnmanaged>	*fBitmapCollection;

};
#endif
