#ifndef PNTBTMAP_H
#define PNTBTMAP_H
//========================================================================================
//
//     File:			PntBtMap.h
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include <BRView.h>
#endif

struct cDrawState;

//========================================================================================
// class cPaintBitmapPane
//
// This class is a derivation of BR_CBitmapPane which is used as the drawing bitmap pane.
//========================================================================================

class cPaintBitmapPane : public BR_CView
{
public:
						cPaintBitmapPane(BR_CView*      	enclosure,
										 BR_CBureaucrat*	supervisor,
										 cDrawState		*State);
						~cPaintBitmapPane();

	

	// Overriden methods
	virtual void		UpdateMenus(BR_CMenuBar& menuBar, BR_Boolean fCallSupervisor);
	virtual BR_Boolean	DoCommand(unsigned short cmdId, 
								  BR_CObject* notifier,
								  BR_Boolean fCallSupervisor);
	virtual void		DoClick(const BR_CPoint& ptMouse, KeyModifiers keys);
	virtual void		Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	virtual void		ReceiveFocus();
	virtual void		LoseFocus(BR_CView *viewReceivingFocus);
	void				SetBitmap(BR_CBitmap* Bitmap);

private:
	cDrawState			*fDrawState;		// State of drawing attributes
	BR_CCaret			*fCaret;    		// pointer to the caret
	BR_CCursor 			*fCursor;   		// pointer to the current cursor.
    BR_CBitmap			*pBitmap;
	
					BR_SETCLASSNAME(cPaintBitmapPane);
};

#endif
