//========================================================================================
//
//     File:			PAINTER.R
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRRCDEFI_H
#include <BRRCDefi.h>
#endif

#ifndef BRTYPES_H
#include <BRTypes.h>
#endif

#ifndef HELPIDS_H
#include "helpids.h"
#endif
#ifndef PAINT_H
#include "paint.h"
#endif

#ifdef BR_BUILD_WIN
	
	//
	//	The main menu system
	//
	resource bclmenu(IDS_APPNAME)
	{
		BR_MenuBar
		{
			BR_TextMenu("&File")
			{
				BR_MenuItem(cmdNew,          "&New\tCtrl+N"),
				BR_MenuItem(cmdOpen,         "&Open ...\tCtrl+O"),
				BR_MenuItem(cmdClose,        "&Close\tCtrl+F4"),
				BR_MenuItem(cmdSave,         "&Save\tCtrl+S"),
				BR_MenuItem(cmdSaveAs,       "Save &As ...\tCtrl+A"),
				BR_MenuItem(cmdRevert,       "&Revert\tCtrl+R"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdPrint,        "&Print ...\tCtrl+P"),
				BR_MenuItem(cmdPrinterPrintSetup, "Prin&ter Setup ..."),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdQuit,         "&Quit\tCtrl+Q")
			}
			BR_TextMenu("&Edit")
			{
				BR_MenuItem(cmdUndo,          "&Undo"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdCut,           "&Cut"),
				BR_MenuItem(cmdCopy,          "&Copy\tCtrl+Insert"),
				BR_MenuItem(cmdPaste,         "&Paste\tShift+Insert"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdClear,         "C&lear"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdClipboard,     "S&how Clipboard")
			}
	   }
	};
	
	
	resource bclmenu(IDS_WINDOWMENU)
	{
		BR_WindowMenu()
		{
			BR_MenuItem (cmdTile,          "&Tile"),
			BR_MenuItem (cmdCascade,       "&Cascade"),
			BR_MenuItem (cmdIcons,         "&Arrange Icons")
		}
	};
	
	resource bclmenu(IDS_HELPMENU)
	{
		BR_HelpMenu()
		{
			BR_MenuItem(cmdAboutBox,   "&About ...")
		}
	};
	
	//
	//	Accerator Table
	//
	
	resource ACCELTABLE IDS_APPNAME
	BEGIN
		'N',			cmdNew,		BEDAT_CONTROL | BEDAT_CHAR;
		'O',			cmdOpen,	BEDAT_CONTROL | BEDAT_CHAR;
		'S',			cmdSave,	BEDAT_CONTROL | BEDAT_CHAR;
		'A',			cmdSaveAs,	BEDAT_CONTROL | BEDAT_CHAR;
		'R',			cmdRevert,	BEDAT_CONTROL | BEDAT_CHAR;
		'P',			cmdPrint,	BEDAT_CONTROL | BEDAT_CHAR;
		'Q',    		cmdQuit,	BEDAT_CONTROL | BEDAT_CHAR;
		BEDVK_F4,		cmdClose,	BEDAT_CONTROL | BEDAT_VIRTUALKEY;
		BEDVK_INSERT,	cmdCopy,	BEDAT_CONTROL | BEDAT_VIRTUALKEY;
		BEDVK_INSERT,	cmdPaste,	BEDAT_SHIFT   | BEDAT_VIRTUALKEY;
	END
#endif

#ifdef BR_BUILD_MAC

	//
	//	The main menu system
	//
	
	resource bclmenu(IDS_APPNAME)
	{
		BR_MenuBar
		{
			BR_TextMenu("\024")
			{
				BR_MenuItem(cmdAboutBox,		  "About Bedrock Paint")
			}
			BR_TextMenu("File")
			{
				BR_MenuItem(cmdNew,          "New/N"),
				BR_MenuItem(cmdOpen,         "Open/O"),
				BR_MenuItem(cmdClose,        "Close/W"),
				BR_MenuItem(cmdSave,         "Save/S"),
				BR_MenuItem(cmdSaveAs,       "Save As/A"),
				BR_MenuItem(cmdRevert,       "Revert/R"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdPrint,        "Print/P"),
				BR_MenuItem(cmdPrinterPrintSetup,   "Printer Setup/T"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdQuit,         "Quit/Q")
			}
			BR_TextMenu("Edit")
			{
				BR_MenuItem(cmdUndo,          "Undo/U"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdCut,           "Cut/X"),
				BR_MenuItem(cmdCopy,          "Copy/C"),
				BR_MenuItem(cmdPaste,         "Paste/P"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdClear,         "Clear/L"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdClipboard,     "Show Clipboard/H")
			}
	   }
	};
	
	
	resource bclmenu(IDS_WINDOWMENU)
	{
		BR_WindowMenu()
		{
			BR_MenuItem (cmdTile,          "Tile"),
			BR_MenuItem (cmdCascade,       "Cascade"),
			BR_MenuItem (cmdIcons,         "Arrange Icons")
		}
	};
	
	resource bclmenu(IDS_HELPMENU)
	{
		BR_HelpMenu()
		{
		}
	};
#endif

#ifdef BR_BUILD_WIN
resource STRTABLE
{
    IDS_APPTITLE,       "Bedrock Paint Program";
}
#endif

//
//  Menu commands to help id mapping
//
resource bclmultilong(IDS_MENUIDTOHELPID)
{
	{
		{cmdTile,			HELPID_WINDOW_TILE},
		{cmdCascade,		HELPID_WINDOW_CASCADE},
		{cmdIcons,			HELPID_WINDOW_ARRANGEICONS},
		//{cmdHelpIndex,		HELPID_INDEX},
		{cmdPrinterPrintSetup,	HELPID_PRINTER_SETUP},
		{cmdClipboard,		HELPID_SHOW_CLIPBOARD},	
		{cmdSetFont,		HELPID_FONT},	
		{cmdAboutBox,		HELPID_ABOUT_BOX},	
		{cmdNew,		 	HELPID_FILE_NEW}, 	
		{cmdOpen,		 	HELPID_FILE_OPEN},	
		{cmdClose,	 		HELPID_FILE_CLOSE},	
		{cmdSave,		 	HELPID_FILE_SAVE},	
		{cmdSaveAs,			HELPID_FILE_SAVE_AS},	
		{cmdRevert,	 		HELPID_FILE_REVERT},	
		{cmdPrint,	 		HELPID_FILE_PRINT},	
		{cmdQuit,		 	HELPID_FILE_QUIT},	
		{cmdUndo,		 	HELPID_EDIT_UNDO},	
		{cmdCut,		 	HELPID_EDIT_CUT},		
		{cmdCopy,		 	HELPID_EDIT_COPY},	
		{cmdPaste,	 		HELPID_EDIT_PASTE},	
		{cmdClear,	 		HELPID_EDIT_CLEAR},	
		{cmdHelpCmd,	 	HELPID_KEYCOMMANDS}		
	}
};

//
// Help id to Help String mapping
//
resource MULTISTRING IDS_STATUSSTRINGHELP
{
	HELPID_NONE,                " ";
	HELPID_WINDOW_TILE,         "Tile the document windows";
	HELPID_WINDOW_CASCADE,      "Cascade the document windows";
	HELPID_WINDOW_ARRANGEICONS, "Arrange the document window icons";
	HELPID_PRINTER_SETUP,		"Printer Setup";
	HELPID_SHOW_CLIPBOARD,		"Show the Clipboard in a window";
	HELPID_FONT,				"This currently sets typeface, size, and style";
	HELPID_ABOUT_BOX,			"Show the About Box for this program";
	HELPID_FILE_NEW, 			"Open a new file";
	HELPID_FILE_OPEN,			"Open an existing file";
	HELPID_FILE_CLOSE,			"Close the current file";
	HELPID_FILE_SAVE,			"Save the current file";
	HELPID_FILE_SAVE_AS,		"Save the current file with a certain file name";
	HELPID_FILE_REVERT,			"Revert back to the previous verion";
	HELPID_FILE_PRINT,			"Print the file";
	HELPID_FILE_QUIT,			"Quit the program";
	HELPID_EDIT_UNDO,			"Undo the last option";
	HELPID_EDIT_CUT,			"Cut the current selected text and put it in the Clipboard";
	HELPID_EDIT_COPY,			"Copy the current selected text to the Clipboard";
	HELPID_EDIT_PASTE,			"Copy the Clipboard to the current cursor position";
	HELPID_EDIT_CLEAR,			"Clear the selected text";
	HELPID_KEYCOMMANDS,			"Help on Command for this editor";
}

//
//	Icons, Cursors, and Bitmaps
//
resource ICON   IDS_APPNAME, 						"paint.ico";
resource CURSOR IDS_APPNAME, 						"paint.cur";
resource BITMAP IDS_APPNAME, 						"paint.bmp";

resource BITMAP	IDB_ERASER_UNSELECT,				"eraser.bmp";
resource BITMAP	IDB_PENCIL_UNSELECT,				"pencil.bmp";
resource BITMAP	IDB_SELECTION_UNSELECT,				"select.bmp";
resource BITMAP	IDB_FLOODFILL_UNSELECT,				"floodfil.bmp";
resource BITMAP	IDB_HAND_UNSELECT,				    "hand.bmp";
resource BITMAP	IDB_SPRAY_UNSELECT,					"spray.bmp";
resource BITMAP IDB_LETTER_UNSELECT,				"letter.bmp";
resource BITMAP IDB_LINE_UNSELECT,					"line.bmp";
resource BITMAP IDB_ELLIPSE_UNSELECT,				"ellip.bmp";
resource BITMAP IDB_FILLELLIPSE_UNSELECT,			"ellipclr.bmp";
resource BITMAP IDB_RECT_UNSELECT,					"rect.bmp";
resource BITMAP IDB_FILLRECT_UNSELECT,				"rectclr.bmp";
resource BITMAP IDB_ROUNDRECT_UNSELECT,				"rndrec.bmp";
resource BITMAP IDB_FILLROUNDRECT_UNSELECT,  		"rndreccl.bmp";
resource BITMAP IDB_POLY_UNSELECT,					"poly.bmp";
resource BITMAP IDB_FILLPOLY_UNSELECT,				"polyclr.bmp";

#ifdef BR_BUILD_WIN
resource CURSOR IDC_CROSSHAIR,						"croshair.cur";	  
resource CURSOR IDC_ERASER,							"eraser.cur";	
resource CURSOR IDC_PENCIL,		  					"pencil.cur";	
resource CURSOR IDC_HAND,		  					"hand.cur";	
resource CURSOR IDC_FLOODFILL,		  				"floodfil.cur";	
resource CURSOR IDC_SPRAY,		  					"spray.cur";	
resource CURSOR IDC_LETTER,		  					"letter.cur";
#endif

#ifdef BR_BUILD_MAC
#pragma native begin
#include "types.r"
#define IDS_APPNAME 0x3000
#include "cursors.h"
resource 'CURS' (IDC_SPRAY) {
    $"01C0 0160 01C0 0080 01C0 0220 07F0 0410"            /* ..`.... .... */
    $"0410 0410 0410 0410 0410 0410 0410 07F0",           /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000",           /* ................ */
    {$1, $B}                                              /* .... */
};

resource 'CURS' (IDC_CROSSHAIR) {
    $"0100 0100 0100 0100 0100 0100 0000 FC7E"            /* ...............~ */
    $"0000 0100 0100 0100 0100 0100 0100 0000",           /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000",           /* ................ */
    {$7, $7}                                                      
};

resource 'CURS' (IDC_ERASER) {
    $"1000 3800 6C00 C600 C700 6D80 38C0 1C60"            /* ..8.l...m8.` */
    $"0E30 0718 038C 01C6 00E6 007E 003D 0003",           /* .0.......~.=.. */
    $"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000",           /* ................ */
    {$3, $3}                                              /* .... */
};

resource 'CURS' (IDC_FLOODFILL) {
    $"0300 0480 0580 06E0 04D0 08A8 1094 214E"            /* .......-.r.!N */
    $"408F 8017 4027 2047 1087 0906 0604 0004",           /* @.@' G...... */
    $"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000",           /* ................ */
    {$F, $D}                                              /* ... */
};

resource 'CURS' (IDC_HAND) {
    $"00E0 03A0 02B8 02A8 02AE 1EAA 16AA 16AA"            /* .....r..t.t.t */
    $"12AA 1002 1002 1002 0802 0804 0408 03F0",           /* .t.............. */
    $"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000",           /* ................ */
    {$5, $9}                                              /* ... */
};

resource 'CURS' (IDC_LETTER) {
	$"0000 0380 0380 0380 0380 0380 0380 0380"
	$"0380 0380 0380 0380 0380 0380 0380",
	$"",
	{$1, $7}
};

resource 'CURS' (IDC_PENCIL) {
    $"C000 B800 6C00 6600 7300 3980 1CC0 0E60"            /* ..l.f.s.9..` */
    $"0730 0398 01FC 00F6 0062 0036 001C 0000",           /* .0......b.6.... */
    $"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
    $"0000 0000 0000 0000 0000 0000 0000 0000",           /* ................ */
    {$0, $0}                                              /* .... */
};
#pragma native end
#endif

//
//	About Box Dialog resource definition
//
resource bclview(IDD_ABOUTBOX_DIALOG)
{
	BR_DialogBox(	"About",
					kHasCloseBox | kHasCaption | kModalDialog,
					220, 180, 150, 70)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore,60, 5, "Bedrock Paint Program"),
			BR_Text(-1, kAdornBefore,60, 15, "Copyright (C) 1992"),
			BR_Text(-1, kAdornBefore,60, 25, "Symantec Corporation"),
			BR_Text(-1, kAdornBefore,60, 60, "Written By: Dave Dodd"),
			BR_DefPushButton(cmdOk, 5,  55,  45, 15, "OK"),
			BR_RBitmapAdorner(-1, kAdornBefore,10, 5, 40, 40, IDS_APPNAME);
		}
	}
};

//
// 	Resource Dialog Box used to inform the user when a feature is
//	is not implemented
//
resource bclview(IDD_NOT_IMPLEMENTED_DIALOG)
{
	BR_DialogBox(	"Future Enhancement",
					kHasCloseBox | kHasCaption | kModalDialog,
					220, 180, 140, 65)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore,10, 10, "This feature is not implemented."),
			BR_DefPushButton(cmdOk, 45,  45,  45, 15, "OK")
		}
	}
};

#ifdef BR_BUILD_MAC
	#pragma native begin
		include $$Shell("BedObjectsFolder")"macbcl.res";
		include $$Shell("BedObjectsFolder")"bcl.res";
		include $$Shell("ObjApp")"Painter" 'CODE';
	#pragma native end
#endif

