#ifndef DRWTOOLS_H
#define DRWTOOLS_H
//========================================================================================
//
//     File:			DrwTools.h
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef PNTTOOLS_H
#include "PntTools.h"
#endif

class BR_CPen;
class BR_CPoint;
struct cDrawState;


//========================================================================================
// class cDrawTool
//
// Base class for all the drawing tools. This class basically sets up the drawing
// environment for drawing to happen. It then calls the DrawAt method to draw at the
// current location of the mouse.
//========================================================================================

class cDrawTool : public cPaintTool
{
public:
					cDrawTool(cDrawState *State, int BitmapResId, int CursorResId);
	virtual			~cDrawTool();
	
	//	Overides
	virtual void	BeginTracking(const BR_CPoint &p); 
	virtual void	KeepTracking(const BR_CPoint &p); 
	virtual void	EndTracking(const BR_CPoint &p);
	
	//	Override this method to draw at point p.
	virtual void	DrawAt(BR_CPoint &p) = 0;
	
protected:
	BR_DrawMode		fOldDrawMode;	// Save the old draw mode while drawing
	BR_CPen			*fPen;
	BR_CPoint		fPreviousPoint;
	BR_CPoint		fEndPoint;
	
	//	Create the pen to draw with.
	virtual	void	CreatePen();
};


//========================================================================================
// class SprayTool
//========================================================================================

class cSprayTool : public cDrawTool
{
public:
				cSprayTool(cDrawState *State);
	virtual		~cSprayTool();

	void		BeginTracking(const BR_CPoint &p); 
	void		DrawAt(BR_CPoint &p);		// Draw a random pixels at location p

private:
	int			fOffset;				// Where to to draw the pixels
	int			fNumberOfPixels;		// Number of Pixels set
	long		fx, fy;					// The points where we put the pixels
	
	enum
	{
		eNumberOfPixelsFactor = 5, eOffsetFactor = 3
	};
};


//========================================================================================
// class cEraserTool
//========================================================================================

class cEraserTool : public cDrawTool
{
public:
				cEraserTool(cDrawState *State);
	virtual		~cEraserTool();
	
	void		CreatePen();			// Setup special pen with WHITE color
	void		DrawAt(BR_CPoint &);	// Draw white a point p
};


//========================================================================================
//	class cPenTool
//========================================================================================

class cPenTool : public cDrawTool
{
public:
				cPenTool(cDrawState *State);
	virtual		~cPenTool();

	void		DrawAt(BR_CPoint &);	// Draw a line to point p
};

#endif