//========================================================================================
//
//     File:			DrwTools.cp
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef STDLIB_H
#include <stdlib.h>
#endif

#ifndef BRGRHELP_H
#include <BRGrHelp.h>
#endif

#ifndef BRVIEW_H
#include <BRView.h>
#endif

#ifndef BRBITMAP_H
#include <BRBitmap.h>
#endif

#ifndef BRPEN_H
#include <BRPen.h>
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

#ifndef DRWTOOLS_H
#include "DrwTools.h"
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif


//========================================================================================
// class cDrawTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cDrawTool::cDrawTool
//----------------------------------------------------------------------------------------

cDrawTool::cDrawTool(cDrawState* State,
					 int BitmapResId,
					 int CursorResId) :
	cPaintTool(State, BitmapResId, CursorResId),
	fPen(NULL)
{
}

//----------------------------------------------------------------------------------------
// cDrawTool::~cDrawTool
//----------------------------------------------------------------------------------------

cDrawTool::~cDrawTool()
{
}

//----------------------------------------------------------------------------------------
// cDrawTool::CreatePen
//----------------------------------------------------------------------------------------

void cDrawTool::CreatePen()
{
	//
	//	Create the pen to draw with.
	//
	fPen = new	BR_CPen(fDrawState->fCurrentLineWidth, 
					 fDrawState->fCurrentColor);	
}



//----------------------------------------------------------------------------------------
// cDrawTool::BeginTracking
//----------------------------------------------------------------------------------------

void cDrawTool::BeginTracking(const BR_CPoint &p)
{
	cPaintTool::BeginTracking(p);

	CreatePen();

	//
	//	Set the Previous and end points
	//
	GetStartPoint(fPreviousPoint);
	GetStartPoint(fEndPoint);
	
	//
	// Set the pen position and start drawing
	//
	BR_CGraphicsToolSelector TempSelector(GetPane(), fPen);
	GetPane()->GetCanvas()->MovePenTo(p);
	fPreviousPoint.fX += 1;		// Adjust draw point by one to adjust for Windows.
	DrawAt(fPreviousPoint);
}

//----------------------------------------------------------------------------------------
// cDrawTool::KeepTracking
//----------------------------------------------------------------------------------------

void cDrawTool::KeepTracking(const BR_CPoint &p)//Override
{
	//
	//	Get the Previous and current points
	//
	GetPreviousPoint(fPreviousPoint);
	cPaintTool::KeepTracking(p);
	fEndPoint = p;

	{	//	Draw to the screen
		BR_CGraphicsToolSelector	TempSelector(GetPane(), fPen);
		DrawAt(fEndPoint);
	}
	
	{	//	Draw to the bitmap
		BR_CDrawInitiator BR_CDrawInitiator(GetPane()  , fDrawState->fCurrentBitmap);
		BR_CGraphicsToolSelector TempSelector(GetPane(), fPen);
		GetPane()->GetCanvas()->MovePenTo(fPreviousPoint);
		DrawAt(fEndPoint);
	}
}

//----------------------------------------------------------------------------------------
// cDrawTool::EndTracking
//----------------------------------------------------------------------------------------

void cDrawTool::EndTracking(const BR_CPoint &p)//Override
{
	//
	//	Clean up...
	//	
	delete	fPen;
	fPen	= NULL;

	cPaintTool::EndTracking(p);
}


//========================================================================================
// class SprayTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cSprayTool::cSprayTool
//----------------------------------------------------------------------------------------

cSprayTool::cSprayTool(cDrawState* State) :
	cDrawTool(State, IDB_SPRAY_UNSELECT, IDC_SPRAY)
{
}

//----------------------------------------------------------------------------------------
// cSprayTool::~cSprayTool
//----------------------------------------------------------------------------------------

cSprayTool::~cSprayTool()
{
}

//----------------------------------------------------------------------------------------
// cSprayTool::BeginTracking
//----------------------------------------------------------------------------------------

void cSprayTool::BeginTracking(const BR_CPoint &p)
{
	cDrawTool::BeginTracking(p);
	fOffset			= fDrawState->fCurrentLineWidth * eOffsetFactor;
	fNumberOfPixels	= fDrawState->fCurrentLineWidth * eNumberOfPixelsFactor;
}

//----------------------------------------------------------------------------------------
// cSprayTool::DrawAt
//----------------------------------------------------------------------------------------

void cSprayTool::DrawAt(BR_CPoint &p)
{
	//
	//	Spray pixels in random fashion around point p
	//
	for (int i=0; i<fNumberOfPixels; ++i)
	{
		fx = p.fX + fOffset - (2*rand()%fOffset) + fOffset/4;
		fy = p.fY + fOffset - (2*rand()%fOffset) - fOffset/2;
		
		GetPane()->GetCanvas()->SetPixel(fx, fy, fDrawState->fCurrentColor);
	}
}


//========================================================================================
// class cEraserTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cEraserTool::cEraserTool
//----------------------------------------------------------------------------------------

cEraserTool::cEraserTool(cDrawState* State) :
	cDrawTool(State, IDB_ERASER_UNSELECT, IDC_ERASER)
{
}

//----------------------------------------------------------------------------------------
// cEraserTool::~cEraserTool
//----------------------------------------------------------------------------------------

cEraserTool::~cEraserTool()
{
}

//----------------------------------------------------------------------------------------
// cEraserTool::CreatePen
//----------------------------------------------------------------------------------------

void cEraserTool::CreatePen()
{
	cDrawTool::CreatePen();

	BR_CColor ColorWhite(kRGBWhite);
	fPen->SetDashColor(ColorWhite);
}

//----------------------------------------------------------------------------------------
// cEraserTool::DrawAt
//----------------------------------------------------------------------------------------

void cEraserTool::DrawAt(BR_CPoint &p)
{
	GetPane()->GetCanvas()->DrawLineTo(p);			// Erase to point
}


//========================================================================================
//	class cPenTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cPenTool::cPenTool
//----------------------------------------------------------------------------------------

cPenTool::cPenTool(cDrawState* State) :
	cDrawTool(State, IDB_PENCIL_UNSELECT, IDC_PENCIL)
{
}

//----------------------------------------------------------------------------------------
// cPenTool::~cPenTool
//----------------------------------------------------------------------------------------

cPenTool::~cPenTool()
{
}

//----------------------------------------------------------------------------------------
// cPenTool::DrawAt
//----------------------------------------------------------------------------------------

void cPenTool::DrawAt(BR_CPoint &p)//Override
{
	GetPane()->GetCanvas()->DrawLineTo(p);			// Current point
}
