//========================================================================================
//
//     File:			ColorGri.cp
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef PAINT_H
#include "Paint.h"
#endif

#ifndef COLORGRI_H
#include "ColorGri.h"
#endif

#ifndef PAINTAPP_H
#include "PaintApp.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

DEFINE_CLASS(cColorGrid, BR_CGrid)

//----------------------------------------------------------------------------------------
// cColorGrid::fcolorArray
//
// Array of colors for the color grid
//----------------------------------------------------------------------------------------

BR_CColor cColorGrid::fcolorArray[cColorGrid::eMaxColors]=
{
	kRGBBlack, kRGBWhite, kRGBRed, kRGBDarkRed, kRGBGreen, kRGBLightGreen,
	kRGBLightBlue, kRGBBlue, kRGBDarkBlue, kRGBYellow, kRGBBrown, kRGBPurple,
	kRGBLightGray, kRGBGray, kRGBDarkGray, kRGBCream
};

//----------------------------------------------------------------------------------------
// cColorGrid::cColorGrid
//----------------------------------------------------------------------------------------

cColorGrid::cColorGrid(BR_CView* enclosure,
					   BR_CBureaucrat* supervisor,
					   cDrawState* State) :
	BR_CGrid(enclosure, supervisor, eNumColumns * eColumnWidth, eNumRows * eRowHeight, 0, 0, kFixedLeft, kFixedTop, kPixelUnits),
	fcurRow(0),
	fcurColumn(0),
	fDrawState(State)
{
	SetGridSize(eNumRows, eNumColumns);
	SetColumnWidth(eColumnWidth);
	SetRowHeight(eRowHeight);
	fDrawState->fCurrentColor = GetCurColor();	// Set the Current Color
}

//----------------------------------------------------------------------------------------
// cColorGrid::~cColorGrid
//----------------------------------------------------------------------------------------

cColorGrid::~cColorGrid()
{
}

//----------------------------------------------------------------------------------------
// cColorGrid::DoCellDraw
//
//  Description:	Called to draw a Cell in the Color Grid.
//
//  Entry:			row		- the cell row.
//					column	- the cell column.
//----------------------------------------------------------------------------------------

void cColorGrid::DoCellDraw(GridRowNumber row, GridRowNumber column)
{
	BR_CRectangle cellRect;
	GetCellRect(cellRect, row, column);
	short curIndex= row*eNumColumns + column;  // index into color array

	BR_CDrawInitiator d1(this);
	BR_CPen cellPen(1, kRGBBlack, kSolidPen);
	BR_CGraphicsToolSelector s1(this, &cellPen);
 
	// Draw the color rectangle
	GetCanvas()->DrawRectangle(cellRect, GetColor(curIndex).GetRGB());

	// If the cell to draw is the currently selected cell then an xor X is
	// drawn over the cell rectangle to indicate that it is active.
	if(row == fcurRow && column == fcurColumn)
	{
		BR_CPen grayPen(kRGBGray);
		BR_CGraphicsToolSelector s1(this, &grayPen);
		BR_CCanvas * canvas = GetCanvas();

		BR_DrawMode oldDrawMode = canvas->SetDrawMode(BEDDM_XORPEN);
		canvas->MovePenTo(cellRect.fLeft, cellRect.fTop);
		canvas->DrawLineTo(cellRect.fRight, cellRect.fBottom);
		canvas->MovePenTo(cellRect.fLeft, cellRect.fBottom);
		canvas->DrawLineTo(cellRect.fRight, cellRect.fTop);
		canvas->SetDrawMode(oldDrawMode);
	}
}

//----------------------------------------------------------------------------------------
// cColorGrid::DoCellClick
//
//  Description:	Called when a color cell is clicked on.
//
//  Entry:			row		- the cell row.
//					column	- the cell column.
//----------------------------------------------------------------------------------------

void cColorGrid::DoCellClick(GridRowNumber row, GridRowNumber column)
{
	short oldRow = GetCurRow();
	short oldColumn = GetCurColumn();
	fcurRow = row;
	fcurColumn = column;
	DoCellDraw(oldRow, oldColumn);				// Draw the old color cell
	DoCellDraw(GetCurRow(), GetCurColumn());	// Draw the new color cell
	fDrawState->fCurrentColor = GetCurColor();	// Set the Current Color
}
