//========================================================================================
//
//     File:			BndTools.c
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRGRHELP_H
#include <BRGrHelp.h>
#endif

#ifndef BRBITMAP_H
#include <BRBitmap.h>
#endif

#ifndef BRWALLPA_H
#include <BRWallpa.h>
#endif

#ifndef BRVIEW_H
#include <BRView.h>
#endif

#ifndef BRPEN_H
#include <BRPen.h>
#endif

#ifndef BNDTOOLS_H
#include "BndTools.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif


//========================================================================================
//	class cRubberBandTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cRubberBandTool::cRubberBandTool
//----------------------------------------------------------------------------------------

cRubberBandTool::cRubberBandTool(cDrawState* State,
								 BR_Boolean FillFlag,
								 int BitmapResourceId,
								 int CursorResId) :
	cPaintTool(State, BitmapResourceId, CursorResId),
	fFilled(FillFlag),
	fPen(NULL)
{
}

//----------------------------------------------------------------------------------------
// cRubberBandTool::~cRubberBandTool
//----------------------------------------------------------------------------------------

cRubberBandTool::~cRubberBandTool()
{
}

//----------------------------------------------------------------------------------------
// cRubberBandTool::BeginTracking
//----------------------------------------------------------------------------------------

void cRubberBandTool::BeginTracking(const BR_CPoint &p)
{
	cPaintTool::BeginTracking (p);
	
	//
	//	Set up the drawing environment
	//
	fOldDrawMode	= GetPane()->GetCanvas()->SetDrawMode(BEDDM_XORPEN);
	fWallPaper		= new BR_CWallPaper(BR_CColor(kRGBTransparent));
	fPen			= new BR_CPen(1, kRGBGray);	
	
	//
	//	Store the first points.
	//
	GetStartPoint(fStartPoint);
	GetStartPoint(fEndPoint);

	//
	//	Move to the start location.
	//
	BR_CGraphicsToolSelector PenSelector(GetPane(), fPen);
	GetPane()->GetCanvas()->MovePenTo(p);
}

//----------------------------------------------------------------------------------------
// cRubberBandTool::KeepTracking
//----------------------------------------------------------------------------------------

void cRubberBandTool::KeepTracking(const BR_CPoint &p)
{
	//
	//	Select drawing environment.
	//
	GetPane()->GetCanvas()->SetDrawMode(BEDDM_XORPEN);
	BR_CGraphicsToolSelector PenSelector(GetPane(), fPen);
	BR_CGraphicsToolSelector WallPaperSelector(GetPane(), fWallPaper);

	//
	//	Delete the old object...
	//
	DrawObject();

	cPaintTool::KeepTracking(p);
	
	//
	//	Draw in the new location
	//
	fEndPoint	= p;
	DrawObject();
}

//----------------------------------------------------------------------------------------
// cRubberBandTool::EndTracking
//----------------------------------------------------------------------------------------

void cRubberBandTool::EndTracking(const BR_CPoint &p)
{
	//
	//	Setup the pen to the real color, linewidth.
	//
	fPen->SetThickness(fDrawState->fCurrentLineWidth);
	fPen->SetDashColor(fDrawState->fCurrentColor);	
	
	//
	//	Create color wallpaper if necessary
	//
	if (fFilled)
	{
		delete fWallPaper;
		fWallPaper	= new BR_CWallPaper(fDrawState->fCurrentColor);
	}
	
	{	//	Draw to the Screen.
		BR_CGraphicsToolSelector PenSelector(GetPane(), fPen);
		BR_CGraphicsToolSelector WallPaperSelector(GetPane(), fWallPaper);
		GetPane()->GetCanvas()->SetDrawMode(fOldDrawMode);
		DrawObject();
	}
	
	{	// Draw to the Bitmap.
		BR_CDrawInitiator  BR_CDrawInitiator(GetPane(), fDrawState->fCurrentBitmap);
		BR_CGraphicsToolSelector PenSelector(GetPane(), fPen);
		BR_CGraphicsToolSelector WallPaperSelector(GetPane(), fWallPaper);
		GetPane()->GetCanvas()->SetDrawMode(fOldDrawMode);
		DrawObject();
	}

	//
	//	Clean up
	//
	delete	fWallPaper;
	delete	fPen;
	fPen	= NULL;

	cPaintTool::EndTracking (p);
}

//----------------------------------------------------------------------------------------
// cRubberBandTool::DrawObject
//----------------------------------------------------------------------------------------

void cRubberBandTool::DrawObject()
{
}


//========================================================================================
//	class cLineTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cLineTool::cLineTool
//----------------------------------------------------------------------------------------

cLineTool::cLineTool(cDrawState* State,
					 int BitmapResourceId) :
	cRubberBandTool(State, FALSE, BitmapResourceId, IDC_LINE)
{
}

//----------------------------------------------------------------------------------------
// cLineTool::~cLineTool
//----------------------------------------------------------------------------------------

cLineTool::~cLineTool()
{
}

//----------------------------------------------------------------------------------------
// cLineTool::DrawObject
//----------------------------------------------------------------------------------------

void cLineTool::DrawObject()
{
	GetPane()->GetCanvas()->MovePenTo(fStartPoint);
	GetPane()->GetCanvas()->DrawLineTo(fEndPoint);
}


//========================================================================================
//	class cSquareTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cSquareTool::cSquareTool
//----------------------------------------------------------------------------------------

cSquareTool::cSquareTool(cDrawState *State, int Filled, int BitmapResourceId) 
		  	:cRubberBandTool(State, Filled, BitmapResourceId, IDC_LINE)
{
}

//----------------------------------------------------------------------------------------
// cSquareTool::~cSquareTool
//----------------------------------------------------------------------------------------

cSquareTool::~cSquareTool()
{
}

//----------------------------------------------------------------------------------------
// cSquareTool::DrawObject
//----------------------------------------------------------------------------------------

void cSquareTool::DrawObject()
{
	GetPane()->GetCanvas()->DrawRectangle(fStartPoint.fX, fStartPoint.fY, fEndPoint.fX, fEndPoint.fY);
}


//========================================================================================
//	class cEllipseTool
//========================================================================================

//----------------------------------------------------------------------------------------
// cEllipseTool::cEllipseTool
//----------------------------------------------------------------------------------------

cEllipseTool::cEllipseTool(cDrawState* State,
						   int Filled,
						   int BitmapResourceId) :
	cRubberBandTool(State, Filled, BitmapResourceId, IDC_LINE)
{
}

//----------------------------------------------------------------------------------------
// cEllipseTool::~cEllipseTool
//----------------------------------------------------------------------------------------

cEllipseTool::~cEllipseTool()
{
}

//----------------------------------------------------------------------------------------
// cEllipseTool::DrawObject
//----------------------------------------------------------------------------------------

void cEllipseTool::DrawObject()
{
	BR_CRectangle EllipseRect(fStartPoint.fX, fStartPoint.fY, fEndPoint.fX, fEndPoint.fY);
	GetPane()->GetCanvas()->DrawEllipse(EllipseRect);
}


//========================================================================================
//	class cRoundRectangle
//========================================================================================

//----------------------------------------------------------------------------------------
// cRoundRectangleTool::cRoundRectangleTool
//----------------------------------------------------------------------------------------

cRoundRectangleTool::cRoundRectangleTool(cDrawState* State,
										 int Filled,
										 int BitmapResourceId) :
	cRubberBandTool(State, Filled, BitmapResourceId, IDC_LINE)
{
}

//----------------------------------------------------------------------------------------
// cRoundRectangleTool::~cRoundRectangleTool
//----------------------------------------------------------------------------------------

cRoundRectangleTool::~cRoundRectangleTool()
{
}

//----------------------------------------------------------------------------------------
// cRoundRectangleTool::DrawObject
//----------------------------------------------------------------------------------------

void cRoundRectangleTool::DrawObject()
{
	BR_CRectangle RoundRect(fStartPoint.fX, fStartPoint.fY, fEndPoint.fX, fEndPoint.fY);
	GetPane()->GetCanvas()->DrawRoundRect(RoundRect, RectangleRoundness, RectangleRoundness);
}
