#ifndef MYDRWVW_H
#define MYDRWVW_H

//========================================================================================
//
//     File:			myDrwVw.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRBUREAU_H
#include <BRBureau.h>
#endif

#ifndef   BRVIEW_H
#include <BRView.h>
#endif

#ifndef   BRSTDDEF_H
#include <BRStdDef.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CModule;
class BR_CObject;
class BR_SResource;
class BR_CRectangle;
class BR_CMenuBar;
class BR_CPoint;

//========================================================================================
//	CLASS CMyDrawView
//========================================================================================

class CMyDrawView : public BR_CView
{
public:
	
	// Constructor/Destructor
	CMyDrawView(BR_CView* enclosure,
		BR_CBureaucrat* supervisor,
		const BR_CModule& module,
		BR_SResource& resource);

    virtual ~CMyDrawView();

	// Drawing
    virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle &area);
	void Hilite(const BR_CRectangle &area);
	
	// Menu operations		
    virtual void UpdateMenus(BR_CMenuBar& menuBar,
									BR_Boolean callSupervisor = TRUE);
	// Command operations
    virtual BR_Boolean DoCommand(BR_CBureaucrat::CommandId commandId,
									BR_CObject* notifier,
									BR_Boolean callSupervisor = TRUE);

	// Mouse operations
    virtual void DoClick(const BR_CPoint& ptMouse, BR_CBureaucrat::KeyModifiers keys);
	
private:

	// Mouse operations
    void SelectObject(const BR_CPoint& ptMouse, BR_CBureaucrat::KeyModifiers keys,
						BR_COrderedCollection& objectList);
	
};

#endif