#ifndef MYDRWNUM_H
#define MYDRWNUM_H

//========================================================================================
//
//     File:			myDrwNum.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRBUREAU_H
#include <BRBureau.h>
#endif

#ifndef   BRPEN_H
#include <BRPen.h>
#endif

#ifndef   BRSTDDEF_H
#include <BRStdDef.h>
#endif

#ifndef   BRVALIDF_H
#include <BRValidF.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CView;
class BR_CModule;
class BR_SResource;

//========================================================================================
//	CLASS CPenSizeField
//========================================================================================

class CPenSizeField : public BR_CNumberField
{
  public:

	// Constructor/Destructor
	CPenSizeField(BR_CView* enclosure,
		BR_CBureaucrat* supervisor,
		const BR_CModule& module,
		BR_SResource& viewResource);
						   
	virtual	~CPenSizeField();
	
	// Accessors
	BR_CPen::PenThickness GetValue();
	
  	// Mutators
	void SetValue(BR_CPen::PenThickness itsThickness);

	// Keystroke operations
    virtual BR_Boolean DoKeyDown(BR_CBureaucrat::Key theKey,
							unsigned short repeatCount,
							BR_Boolean callSupervisor = TRUE);

	// Validation operations
	BR_Boolean IsValid();

private:
	BR_CPen::PenThickness fValue;

};

//----------------------------------------------------------------------------------------
// CPenSizeField::SeValue
//----------------------------------------------------------------------------------------
BR_CPen::PenThickness CPenSizeField::GetValue()
{
	return (fValue);
}

#endif