#ifndef MYDRWMOU_H
#define MYDRWMOU_H

//========================================================================================
//
//     File:			myDrwMou.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRBEDEXC_H
#include <BRBedExc.h>
#endif

#ifndef   BRMOUSEA_H
#include <BRMouseA.h>
#endif

#ifndef   BRPEN_H
#include <BRPen.h>
#endif

#ifndef   BRRECT_H
#include <BRRect.h>
#endif

#ifndef   BRSTDDEF_H
#include <BRStdDef.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CModule;
class BR_CString;
class BR_CView;

class CMyDrawDocument;
class CMyDrawObject;

//========================================================================================
//	CLASS CMyMouseAction
//========================================================================================

class CMyMouseAction : public BR_CMouseAction
{
public:

	// Constructor/Destructor
	CMyMouseAction(BR_CView* paneToTrackIn);
	virtual ~CMyMouseAction();

	// Accessors	
	virtual	void GetDescription(BR_CString& description) const;
	virtual BR_CMultiStringList::StringId GetDescriptionIndex() const = 0 ;

	// Tracking operations
    virtual void BeginTracking(const BR_CPoint& startPoint);
    virtual void KeepTracking(const BR_CPoint& currentPoint);
    virtual void EndTracking(const BR_CPoint& currentPoint);

	// Drawing
    virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& updateArea);
	
	// Action operations
	virtual BR_Boolean Do();
	virtual BR_Boolean Redo();
	virtual BR_Boolean Undo();
	
	// Draw Object Operations
	virtual CMyDrawObject* CreateDrawObject() = 0;
	virtual void RemoveLastObject();
	virtual void RestoreLastObject();
	
protected:

	// Accessors
	CMyDrawDocument* GetMyDrawDocument();

	BR_CPoint GetStartingPoint();
	BR_CPoint GetEndingPoint();

	// Drawing
	virtual void ShowFeedback();
	virtual	void DoShowFeedback() = 0;
	
	// Tracking Operations
	virtual	void DoConstrain(BR_CPoint& currentPoint) = 0;

	// Utility Method
	float GetDistance();

	// Data Members
	BR_CPen				fPen;			// This should be a BR_CDeferredPen, but that class needs a a fuller set of constructors.

	BR_CModule*			fUndoStringModule;
	BR_ResourceId		fUndoStringResourceId;

	CMyDrawObject*		fLastDrawObject;
	Boolean				fOwnLastDrawObject;

};

//----------------------------------------------------------------------------------------
// CMyMouseAction::GetMyDrawDocument
//----------------------------------------------------------------------------------------

inline CMyDrawDocument* CMyMouseAction::GetMyDrawDocument()
{
	return ((CMyDrawDocument*)(GetPane()->GetDocument()));
}

//========================================================================================
//	CLASS CMyLineAction
//========================================================================================

class CMyLineAction : public CMyMouseAction
{
public:
	// Constructor/Destructor
	CMyLineAction(BR_CView* paneToTrackIn);
	virtual ~CMyLineAction();

	// Accessors	
	virtual BR_CMultiStringList::StringId GetDescriptionIndex() const;
	
	// Action operations
	virtual	CMyDrawObject* CreateDrawObject();
	
protected:

	// Drawing
	virtual	void DoShowFeedback();
	
	// Tracking Operations
	virtual void DoConstrain(BR_CPoint& currentPoint);
};

//========================================================================================
//	CLASS CMyAreaAction
//========================================================================================

class CMyAreaAction : public CMyMouseAction
{
public:

	// Constructor/Destructor
	CMyAreaAction(BR_CView* paneToTrackIn);
	virtual ~CMyAreaAction();

protected:

	// Tracking Operations
	virtual	void DoConstrain(BR_CPoint& currentPoint);

};

//========================================================================================
//	CLASS CMyRectAction
//========================================================================================

class CMyRectAction : public CMyAreaAction
{
public:

	// Constructor/Destructor
	CMyRectAction(BR_CView* paneToTrackIn);
	virtual ~CMyRectAction();

	// Accessors
	virtual BR_CMultiStringList::StringId GetDescriptionIndex() const;

	// Action operations
	virtual	CMyDrawObject* CreateDrawObject();

protected:

	// Drawing
	virtual	void DoShowFeedback();
};

//========================================================================================
//	CLASS CMyEllipseAction
//========================================================================================

class CMyEllipseAction : public CMyAreaAction
{
public:

	// Constructor/Destructor
	CMyEllipseAction(BR_CView* paneToTrackIn);
	virtual ~CMyEllipseAction();

	// Accessors
	virtual BR_CMultiStringList::StringId GetDescriptionIndex() const;

	// Action operations
	virtual	CMyDrawObject* CreateDrawObject();
	
protected:

	// Drawing
	virtual	void DoShowFeedback();
};

//========================================================================================
//	CLASS CMyRRectAction
//========================================================================================

class CMyRRectAction : public CMyRectAction
{
public:

	// Constructor/Destructor
	CMyRRectAction(BR_CView* paneToTrackIn, 
					const BR_Distance itsWidth, const BR_Distance itsHeight);
	virtual ~CMyRRectAction();

	// Accessors
	virtual BR_CMultiStringList::StringId GetDescriptionIndex() const;

	// Action operations
	virtual	CMyDrawObject* CreateDrawObject();
	
protected:

	// Drawing
	virtual	void DoShowFeedback();
	
private:

	// Data Members
	BR_Distance	fWidth;
	BR_Distance	fHeight;
};

//========================================================================================
//	CLASS XDrawObjectTooSmall
//========================================================================================

class XDrawObjectTooSmall: public BR_XBedException
{
public:
	XDrawObjectTooSmall();
	virtual ~XDrawObjectTooSmall();
	
	__EXCEPTION_DEFINE(XDrawObjectTooSmall);
};

#endif