#ifndef MYDRWDOC_H
#define MYDRWDOC_H
//========================================================================================
//
//     File:			myDrwDoc.h
//     Release Version:	$Revision$
//
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRDOCUME_H
#include <BRDocume.h>
#endif

#ifndef   BRBUREAU_H
#include <BRBureau.h>
#endif

#ifndef   BRPEN_H
#include <BRPen.h>
#endif

#ifndef   BRSTDDEF_H
#include <BRStdDef.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CApplication;
class BR_CMenuBar;
class BR_CObject;
class BR_COrderedCollection;
class BR_CStr32;
class BR_CWindow;

class CMyDrawObject;
class CMyDrawView;

//========================================================================================
//	CLASS CMyDrawDocument
//========================================================================================

class CMyDrawDocument : public BR_CDocument
{
  public:

	// Constructor/Destructor
	CMyDrawDocument(BR_CApplication* application);
	virtual ~CMyDrawDocument();

	// Accessors
	BR_COrderedCollection& GetObjectList();
	const BR_CDeferredPen& GetPen();
	BR_CBureaucrat::CommandId GetToolCommand();
	
	// Mutators
	void SetPenThickness(BR_CPen::PenThickness newThickness);
	
	// Window operations
    virtual void NewWindow();
	
	// Menu operations		
    virtual void UpdateMenus(BR_CMenuBar& menuBar,
									BR_Boolean callSupervisor = TRUE);
	// Command operations
    virtual BR_Boolean DoCommand(CommandId commandId,
									BR_CObject* notifier,
									BR_Boolean callSupervisor = TRUE);


    // Object operations
	void AddDrawObject(CMyDrawObject* object);
	void RemoveDrawObject(CMyDrawObject* object);
    
	// Selection operations
	virtual void SelectAllObjects();
    virtual void DeselectAllObjects();

  private:
  
  	// Accessors
	void GetUnitString(BR_CStr32& theStr);
	
	// Dialogs
	void RunPenSetupDialog();
	
	// Data Members
	BR_COrderedCollection		fObjectList;

	BR_CDeferredPen				fPen;
	BR_CWindow*					fWindow;
	CMyDrawView*				fMainView;

	CommandId					fToolCommand;
};

//----------------------------------------------------------------------------------------
// CMyDrawDocument::GetObjectList
//----------------------------------------------------------------------------------------

inline BR_COrderedCollection& CMyDrawDocument::GetObjectList()
{
	return (fObjectList);
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::GetPen
//----------------------------------------------------------------------------------------

inline const BR_CDeferredPen& CMyDrawDocument::GetPen()
{
	return (fPen);
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::GetToolCommand
//----------------------------------------------------------------------------------------

inline BR_CBureaucrat::CommandId CMyDrawDocument::GetToolCommand()
{
	return (fToolCommand);
}

#endif