//===================================================================================
//
//     File:			EdTimeCh.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDTIMECH_H
#include "EDTimeCh.h"
#endif

DEFINE_CLASS(cEdTimerChore, BR_CTimerChore);

//-----------------------------------------------------------------------------------
// cEdTimerChore::cEdTimerChore
//
// Constructor for the cEdTimerChore class
//-----------------------------------------------------------------------------------

cEdTimerChore::cEdTimerChore(cEdStatusBar *edStatusBar)
			  :BR_CTimerChore(edStatusBar, 1000)
{
}

//-----------------------------------------------------------------------------------
// cEdTimerChore::~cEdTimerChore
//
// Destructor for the cEdTimerChore class
//-----------------------------------------------------------------------------------

cEdTimerChore::~cEdTimerChore()
{
}

//-----------------------------------------------------------------------------------
// cEdTimerChore::Do
//
// The method that is executed after every time interval. It updates the time on the
// status bar.
//-----------------------------------------------------------------------------------

BR_Boolean cEdTimerChore::Do()
{
 	// Get the current time
	BR_CTime curTime;

	// Update the status bar
	((cEdStatusBar *)GetPane())->UpdateTime(curTime);

	return(TRUE);
}
