//===================================================================================
//
//     File:			EdStatBr.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDITTEXT_H
#include "EditText.h"
#endif

#ifndef EDRECT_H
#include "EdRect.h"
#endif

#ifndef EDSTATBR_H
#include "EdStatBr.h"
#endif

#ifndef ED3DADRN_H
#include "Ed3DAdrn.h"
#endif

#ifndef BRAPPDES_H
#include <BRAppDes.h>
#endif

#ifndef BRCHRSTR_H
#include <BRChrStr.h>
#endif

DEFINE_CLASS(cEdStatusBar, BR_CStatusBar);

//-----------------------------------------------------------------------------------
// cEdStatusBar::cEdStatusBar
//
// Constructor the cEdStatusBar class
//-----------------------------------------------------------------------------------

cEdStatusBar::cEdStatusBar(BR_CAppDesktop *enclosure)
			 :BR_CStatusBar(enclosure, 25, 3, BR_CAppDesktop::kBottomPane)
{
	// Create a three-D adorner which will be shared by all the rectangles
	cThreeDAdorner *threeDAdorner = new cThreeDAdorner(IDA_THREEDADORNER);

	// Create cStatusRect in which the Help Status is displayed
	fHelpRect = new cStatusRect(this,
								this,
								0,
								357, 20, 3, 3);
	fHelpRect->AddAdorner(threeDAdorner, kAdornBefore);
	
	// Create the cStatusRect in which the current row number is displayed
	fLineRect = new cStatusRect(this, 
								this,
								0,
								85, 20, 365, 20);
	fLineRect->AddAdorner(threeDAdorner, kAdornBefore);

	// Create the cStatusRect in which the current column number is displayed
	fColumnRect = new cStatusRect(this,
								  this,
								  0,
								  85, 20, 450, 3);
	fColumnRect->AddAdorner(threeDAdorner, kAdornBefore);

	// Create the cStatusRect in which the current time is displayed
	fTimeRect = new cStatusRect(this,
								this,
								0,
								75, 20, 545, 3);
	fTimeRect->AddAdorner(threeDAdorner, kAdornBefore);
}

//-----------------------------------------------------------------------------------
// cEdStatusBar::~cEdStatusBar
//
// Destructor for the cEdStatusBar class
//-----------------------------------------------------------------------------------

cEdStatusBar::~cEdStatusBar()
{
}

//-----------------------------------------------------------------------------------
// cEdStatusBar::UpdateHelpString
//
// Updates the string in the help rectangle
//-----------------------------------------------------------------------------------

void cEdStatusBar::UpdateHelpString(const BR_TString<BR_Char>& helpString)
{
	fHelpRect->SetText(helpString);
}

//-----------------------------------------------------------------------------------
// cEdStatusBar::UpdateLineNumber
//
// Updates the number in the line rectangle
//-----------------------------------------------------------------------------------

void cEdStatusBar::UpdateLineNumber(const BR_CStaticText::LineNumber lineNo)
{
	char lineNoString[10];
	::sprintf(lineNoString, "%7ld", lineNo);

	BR_CCharString32 lineString = "Row: ";
	lineString += lineNoString;

	fLineRect->SetText(lineString);
}

//-----------------------------------------------------------------------------------
// cEdStatusBar::UpdateColumnNumber
//
// Updates the number in the column rectangle
//-----------------------------------------------------------------------------------

void cEdStatusBar::UpdateColumnNumber(const BR_CStaticText::ColumnNumber columnNo)
{
	char columnNoString[10];
	::sprintf(columnNoString, "%7ld", columnNo);

	BR_CCharString32 columnString = "Col: ";
	columnString += columnNoString;

	fColumnRect->SetText(columnString);
}

//-----------------------------------------------------------------------------------
// cEdStatusBar::UpdateTime
//
// Updates the time in the time rectangle
//-----------------------------------------------------------------------------------

void cEdStatusBar::UpdateTime(const BR_CTime& time)
{
	BR_CCharString32	timeString;		// String to hold the current time
	char		tempString[10];	// Temporary string to hold the numbers

	// Get the current hour
	::sprintf(tempString,"%2d", time.GetHour());
	timeString = tempString;
	timeString += ":";

	// Get the current minute
	::sprintf(tempString,"%02d", time.GetMinute());
	timeString += tempString;
	timeString += ":";

	// Get the current seconds
	::sprintf(tempString,"%02d", time.GetSecond());
	timeString += tempString;
	
	fTimeRect->SetText(timeString);
}
