#ifndef EDRECT_H
#define EDRECT_H
//===================================================================================
//
//     File:			EdRect.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef BRVIEW_H
#include <BRView.h>
#endif

#ifndef BRCHRSTR_H
#include <BRChrStr.h>
#endif

//===================================================================================
// class cStatusRect
//
// This class is a derivation of BR_CDrawRectangle which is used to make rectangles 
// on the status line in which text is displayed.
//===================================================================================

class cStatusRect : public BR_CView
{
public:
					cStatusRect(BR_CView			*enclosure,
								BR_CBureaucrat		*supervisor,
								ViewId				viewID,
								BR_Distance			width,
								BR_Distance			height,
								BR_Coordinate		x,
								BR_Coordinate		y);
	virtual         ~cStatusRect();
	
	virtual void    Draw(BR_CView &view);
	void			SetText(const BR_TString<BR_Char> &textStr);

private:
	BR_CCharString255 fRectText;					// The text to be displayed
													// on the status bar
	void			DrawText(BR_CView &view);

					BR_SETCLASSNAME(cStatusRect);
};

#endif
