//===================================================================================
//
//     File:			EditText.r
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDITTEXT_H
#include "EditText.h"
#endif

#ifndef EDHELPID_H
#include "EdHelpId.h"
#endif

#ifndef BRTYPES_H
#include <BRTypes.h>
#endif

#ifndef BRFONT_K
#include <BRFont.k>
#endif


#ifdef BR_BUILD_WIN
	resource STRTABLE
	BEGIN
		IDS_APPTITLE,       "Bedrock Text Editor";
		IDS_APPLICATION,    "EDITTEXT.EXE";
		IDS_HELPMENU,   	"Help";
		IDS_HELPFILE,   	"edhelp.hlp"; 
	END
	
	//
	//	The main menu system
	//
	resource bclmenu(IDS_APPLICATION)
	{
		BR_MenuBar
		{
			BR_TextMenu("&File")
			{
				BR_MenuItem(cmdNew,					"&New\tCtrl+N"),
				BR_MenuItem(cmdOpen,				"&Open ...\tCtrl+O"),
				BR_MenuItem(cmdClose,				"&Close\tCtrl+F4"),
				BR_MenuItem(cmdSave,				"&Save\tCtrl+S"),
				BR_MenuItem(cmdSaveAs,				"Save &As ...\tCtrl+A"),
				BR_MenuItem(cmdRevert,				"&Revert\tCtrl+R"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdPrint,				"&Print ...\tCtrl+P"),
				BR_MenuItem(cmdPrinterPrintSetup,	"Prin&ter Setup ..."),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdQuit,				"&Quit\tCtrl+Q")
			}
			BR_TextMenu("&Edit")
			{
				BR_MenuItem(cmdUndo,		"&Undo"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdCut,			"&Cut"),
				BR_MenuItem(cmdCopy,		"&Copy\tCtrl+Insert"),
				BR_MenuItem(cmdPaste,		"&Paste\tShift+Insert"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdClear,		"C&lear")
				BR_MenuItemSeparator,
				BR_MenuItem(cmdSelectAll,	"&Select All"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdClipboard,	"S&how Clipboard")
			}
			BR_TextMenu("&Search")
			{
				BR_MenuItem(cmdFind,			"&Find ..."),
				BR_MenuItem(cmdFindAgain,		"Find &Again"),
				BR_MenuItem(cmdReplace,			"&Replace ..."),
				BR_MenuItem(cmdReplaceAgain,	"Replace A&gain"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdGoToLine,		"&Go to Line Number ...")
			}
	   }
	};

	resource bclmenu(IDS_WINDOWMENU)
	{
		BR_WindowMenu()
		{
			BR_MenuItem (cmdTile,		"&Tile"),
			BR_MenuItem (cmdCascade,	"&Cascade"),
			BR_MenuItem (cmdIcons,		"&Arrange Icons")
		}
	};

	resource bclmenu(IDS_HELPMENU)
	{
		BR_HelpMenu()
		{
			BR_MenuItem(cmdHelpIndex,	"&Index"),
			BR_MenuItem(cmdHelpCmd,		"&Commands"),
			BR_MenuItem(cmdAboutBox,	"&About ...")
		}
	};
	
	//
	//	Accerator Table
	//
	resource ACCELTABLE IDS_APPLICATION
	BEGIN
		'N',			cmdNew,		BEDAT_CONTROL | BEDAT_CHAR;
		'O',			cmdOpen,	BEDAT_CONTROL | BEDAT_CHAR;
		'S',			cmdSave,	BEDAT_CONTROL | BEDAT_CHAR;
		'A',			cmdSaveAs,	BEDAT_CONTROL | BEDAT_CHAR;
		'R',			cmdRevert,	BEDAT_CONTROL | BEDAT_CHAR;
		'P',			cmdPrint,	BEDAT_CONTROL | BEDAT_CHAR;
		'Q',    		cmdQuit,	BEDAT_CONTROL | BEDAT_CHAR;
		BEDVK_F4,		cmdClose,	BEDAT_CONTROL | BEDAT_VIRTUALKEY;
		BEDVK_INSERT,	cmdCopy,	BEDAT_CONTROL | BEDAT_VIRTUALKEY;
		BEDVK_INSERT,	cmdPaste,	BEDAT_SHIFT   | BEDAT_VIRTUALKEY;
	END
	
	//
	//	Icons, Cursors, and Bitmaps
	//
	resource ICON   IDS_APPLICATION, "ed.ico";
	resource CURSOR IDS_APPLICATION, "ed.cur";
#endif


#ifdef BR_BUILD_MAC
	//
	//	The main menu system
	//
	resource bclmenu(IDS_APPLICATION)
	{
		BR_MenuBar
		{
			BR_TextMenu("\024")
			{
				BR_MenuItem(cmdAboutBox,	"About EditText")
			}
			BR_TextMenu("File")
			{
				BR_MenuItem(cmdNew,					"New/N")
				BR_MenuItem(cmdOpen,				"Open/O")
				BR_MenuItemSeparator
				BR_MenuItem(cmdClose,				"Close/W")
				BR_MenuItem(cmdSave,				"Save/S")
				BR_MenuItem(cmdSaveAs,				"Save As")
				BR_MenuItem(cmdRevert,				"Revert")
				BR_MenuItemSeparator
				BR_MenuItem(cmdPrint,				"Print/P")
				BR_MenuItem(cmdPrinterPrintSetup,	"Page Setup")
				BR_MenuItemSeparator
				BR_MenuItem(cmdQuit,				"Quit/Q")
			}
			BR_TextMenu("Edit")
			{
				BR_MenuItem(cmdUndo,		"Undo/Z")
				BR_MenuItemSeparator
				BR_MenuItem(cmdCut,			"Cut/X")
				BR_MenuItem(cmdCopy,		"Copy/C")
				BR_MenuItem(cmdPaste,		"Paste/V")
				BR_MenuItemSeparator
				BR_MenuItem(cmdClear,		"Clear")
				BR_MenuItemSeparator
				BR_MenuItem(cmdSelectAll,	"Select All/A")
				BR_MenuItemSeparator
				BR_MenuItem(cmdClipboard,	"Show Clipboard")
			}
			BR_TextMenu("Search")
			{
				BR_MenuItem(cmdFind,			"Find/F"),
				BR_MenuItem(cmdFindAgain,		"Find Again/G"),
				BR_MenuItem(cmdReplace,			"Replace/R"),
				BR_MenuItem(cmdReplaceAgain,	"Replace Again/H"),
				BR_MenuItemSeparator,
				BR_MenuItem(cmdGoToLine,		"Go to Line Number")
			}
	   }
	};
	
	resource bclmenu(IDS_WINDOWMENU)
	{
		BR_WindowMenu()
		{
			BR_MenuItem (cmdTile,		"Tile")
			BR_MenuItem (cmdCascade,	"Cascade")
		}
	};
	
	resource bclmenu(IDS_HELPMENU)
	{
		BR_HelpMenu()
		{
			BR_MenuItem(cmdHelpIndex,	"Index")
			BR_MenuItem(cmdHelpCmd,		"Commands")
		}
	};
	
	#pragma native begin
		include $$Shell("BedObjectsFolder")"bcl.res";
		include $$Shell("BedObjectsFolder")"macbcl.res";
		include $$Shell("ObjApp")"EditText" 'CODE';
	#pragma native end	
#endif


//
//  Menu commands to help id mapping
//
resource bclmultilong(IDS_MENUIDTOHELPID)
{
	{
		{cmdTile,        		HELPID_WINDOW_TILE},
		{cmdCascade,     		HELPID_WINDOW_CASCADE},
		{cmdIcons,       		HELPID_WINDOW_ARRANGEICONS},
		{cmdHelpIndex,   		HELPID_INDEX},
		{cmdPrinterPrintSetup,	HELPID_PRINTER_SETUP},
		{cmdSelectAll,			HELPID_SELECT_ALL},
		{cmdClipboard, 			HELPID_SHOW_CLIPBOARD},	
		{cmdFind,		 		HELPID_FIND},	
		{cmdFindAgain,			HELPID_FIND_AGAIN},	
		{cmdReplace,	 		HELPID_REPLACE},	
		{cmdReplaceAgain,		HELPID_REPLACE_AGAIN},	
		{cmdGoToLine,	 		HELPID_GO_TO_LINE},	
		{cmdAboutBox,     		HELPID_ABOUT_BOX},	
		{cmdNew,		 		HELPID_FILE_NEW}, 	
		{cmdOpen,		 		HELPID_FILE_OPEN},	
		{cmdClose,	 			HELPID_FILE_CLOSE},	
		{cmdSave,		 		HELPID_FILE_SAVE},	
		{cmdSaveAs,	 			HELPID_FILE_SAVE_AS},	
		{cmdRevert,	 			HELPID_FILE_REVERT},	
		{cmdPrint,	 			HELPID_FILE_PRINT},	
		{cmdQuit,		 		HELPID_FILE_QUIT},	
		{cmdUndo,			 	HELPID_EDIT_UNDO},	
		{cmdCut,			 	HELPID_EDIT_CUT},		
		{cmdCopy,			 	HELPID_EDIT_COPY},	
		{cmdPaste,	 			HELPID_EDIT_PASTE},	
		{cmdClear,	 			HELPID_EDIT_CLEAR},	
		{cmdHelpCmd,		 	HELPID_KEYCOMMANDS}		
	}
};

//
// Help id to Help string mapping
//
resource MULTISTRING IDS_STATUSSTRINGHELP
{
	HELPID_NONE,                " ";
	HELPID_WINDOW_TILE,         "Tile the document windows";
	HELPID_WINDOW_CASCADE,      "Cascade the document windows";
	HELPID_WINDOW_ARRANGEICONS, "Arrange the document window icons";
	HELPID_INDEX,               "Go to the help index";
	HELPID_PRINTER_SETUP,		"Printer Setup";
	HELPID_SELECT_ALL,			"Select the entire text document";
	HELPID_SHOW_CLIPBOARD,		"Show the Clipboard in a window";
	HELPID_FIND,				"Find a string";
	HELPID_FIND_AGAIN,			"Find a string again";
	HELPID_REPLACE,				"Search for a string and replace it with another string";
	HELPID_REPLACE_AGAIN,		"Search and replace again";
	HELPID_GO_TO_LINE,			"Go to a line number in the document";
	HELPID_ABOUT_BOX,			"Show the About Box for this program";
	HELPID_FILE_NEW, 			"Open a new file";
	HELPID_FILE_OPEN,			"Open an existing file";
	HELPID_FILE_CLOSE,			"Close the current file";
	HELPID_FILE_SAVE,			"Save the current file";
	HELPID_FILE_SAVE_AS,		"Save the current file with a certain file name";
	HELPID_FILE_REVERT,			"Revert back to the previous verion";
	HELPID_FILE_PRINT,			"Print the file";
	HELPID_FILE_QUIT,			"Quit the program";
	HELPID_EDIT_UNDO,			"Undo the last option";
	HELPID_EDIT_CUT,			"Cut the current selected text and put it in the Clipboard";
	HELPID_EDIT_COPY,			"Copy the current selected text to the Clipboard";
	HELPID_EDIT_PASTE,			"Copy the Clipboard to the current cursor position";
	HELPID_EDIT_CLEAR,			"Clear the selected text";
	HELPID_KEYCOMMANDS,			"Help on Command for this editor";
}
	
//
//	Bitmap
//
resource BITMAP IDS_ABOUT, "edabout.bmp";

//
//	Dialog box resource for finding text
//
resource bclview(IDV_FIND_DIALOG)
{
	BR_DialogBoxFont("Find",
					 kHasCloseBox | kHasCaption | kModalDialog,
					 20, 20, 160, 75,
					 kHelvetica, 10, kBold)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore, 20, 8, "Search for:"),
			BR_EditField(IDT_SEARCH_TEXT, 20, 18, 120, 16),
			BR_DefPushButton(cmdOk, 20, 48, 50, 15, "OK"),
			BR_PushButton(cmdCancel, 90, 48, 50, 15, "Cancel")
		}
	}
};

//
// Dialog box resource for finding and replacing text
//
resource bclview(IDV_REPLACE_DIALOG)
{
	BR_DialogBoxFont("Replace",
					 kHasCloseBox | kHasCaption | kModalDialog,
					 20, 20, 160, 100,
					 kHelvetica, 10, kBold)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore, 20, 5, "Search for:"),
			BR_EditField(IDT_SEARCH_TEXT, 20, 15, 120, 16),
			BR_Text(-1, kAdornBefore, 20, 38, "Replace with:"),
			BR_EditField(IDT_REPLACE_TEXT, 20, 48, 120, 16),
			BR_DefPushButton(cmdOk, 20, 75, 50, 15, "OK"),
			BR_PushButton(cmdCancel, 90, 75, 50, 15, "Cancel")
		}
	}
};

//
// Dialog box resource for going to a specific line number
//
resource bclview(IDV_GOTOLINE_DIALOG)
{
	BR_DialogBoxFont("Go To Line Number",
					 kHasCloseBox | kHasCaption | kModalDialog,
					 20, 20, 160, 80,
					 kHelvetica, 10, kBold)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore, 20, 8, "Go To Line Number:"),
			BR_EditField(IDT_LINENO_TEXT, 20, 18, 120, 16),
			BR_DefPushButton(cmdOk, 20, 50, 50, 15, "OK"),
			BR_PushButton(cmdCancel, 90, 50, 50, 15, "Cancel")
		}
	}
};

//
// Dialog box resource used when a string cannot be found 
//
resource bclview(IDV_NOTFOUND_DIALOG)
{
	BR_DialogBoxFont("Search Status",
					 kHasCloseBox | kHasCaption | kModalDialog,
					 20, 20, 150, 60,
					 kHelvetica, 10, kBold)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore, 48, 12, "String Not Found!"),
			BR_DefPushButton(cmdOk, 50, 35, 50, 15, "OK")
		}
	}
};

//
// 	Dialog box resource used for About Box
//
resource bclview(IDV_ABOUTBOX_DIALOG)
{
	BR_DialogBoxFont("About",
					 kHasCloseBox | kHasCaption | kModalDialog,
					 220, 180, 140, 95,
					 kHelvetica, 10, kBold)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore, 39, 10, "Bedrock Text Editor"),
			BR_Text(-1, kAdornBefore, 37, 20, "Copyright (C) 1992-3"),
			BR_Text(-1, kAdornBefore, 35, 30, "Symantec Corporation"),
			BR_Text(-1, kAdornBefore, 53, 45, "Written By:"),
			BR_Text(-1, kAdornBefore, 27, 55, "Dale Oberg and Leon Venter"),
			BR_DefPushButton(cmdOk, 45, 72, 50, 15, "OK")
		}
	}
};

//
// 	Resource dialog box used to inform the user when a feature is
//	is not implemented
//
resource bclview(IDV_NOTIMPLEMENTED_DIALOG)
{
	BR_DialogBoxFont("Future Enhancement",
					 kHasCloseBox | kHasCaption | kModalDialog,
					 220, 180, 140, 65,
					 kHelvetica, 10, kBold)
	{
		BR_DialogPane(0)
		{
			BR_Text(-1, kAdornBefore, 20, 10, "This feature is not implemented."),
			BR_DefPushButton(cmdOk, 45, 45, 50, 15, "OK")
		}
	}
};
