#ifndef EDAPP_H
#define EDAPP_H
//===================================================================================
//
//     File:			EdApp.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef BRAPPLIC_H
#include <BRApplic.h>
#endif

class cEdStatusBar;
class BR_CTimerChore;

//-----------------------------------------------------------------------------------
// cEditApp
//
// This is the application class for the Bedrock Text Editor
//-----------------------------------------------------------------------------------

class cEditApp : public BR_CApplication
{
public:
                      	 	cEditApp(BR_CSystem *system);
	virtual            	 	~cEditApp();

	// Overridden virtual methods
	virtual BR_CAppDesktop*	MakeAppDesktop();
	virtual void       	 	UpdateMenus(BR_CMenuBar &menuBar,
										BR_Boolean fCallSupervisor);
	virtual BR_Boolean 	 	DoCommand(CommandId cmdId,
									  BR_CObject *notifier,
								  	  BR_Boolean fCallSupervisor);
	virtual BR_CDocument*	CreateDocument();
	virtual BR_CDocument*	OpenDocument(BR_CFileSpecification &fileSpec);
	virtual BR_Boolean 	 	ShowHelpStatusString(const BR_TString<BR_Char>& helpStatusString);

	// Non-virtual methods
	cEdStatusBar*			GetStatusBar();

private:
	void 					DoAboutBox();

#ifdef BR_BUILD_WIN
private:
	cEdStatusBar			*fWinEdStatusBar;
	BR_CTimerChore			*fWinTimerChore;
#endif
							BR_SETCLASSNAME(cEditApp);
};

#endif
