//===================================================================================
//
//     File:			EdApp.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDITTEXT_H
#include "EditText.h"
#endif

#ifndef EDAPP_H
#include "EdApp.h"
#endif

#ifndef EDDOC_H
#include "EdDoc.h"
#endif

#ifndef BRMNUBAR_H
#include <BRMnuBar.h>
#endif

#ifndef BRDLGDIR_H
#include <BRDlgDir.h>
#endif

#ifndef BRCMDIDS_H
#include <BRCmdIds.h>
#endif

#ifndef BRWINDOW_H
#include <BRWindow.h>
#endif

DEFINE_CLASS(cEditApp, BR_CApplication);

//-----------------------------------------------------------------------------------
// cEditApp::cEditApp
//
// The constructor for cEditApp
//-----------------------------------------------------------------------------------

cEditApp::cEditApp(BR_CSystem* system) :
	BR_CApplication(system, this, IDS_APPLICATION)
{
#ifdef BR_BUILD_WIN
	fWinEdStatusBar = NULL;
	fWinTimerChore = NULL;
#endif
}

//-----------------------------------------------------------------------------------
// cEditApp::~cEditApp
//
// The destructor the cEditApp class.
//-----------------------------------------------------------------------------------

cEditApp::~cEditApp()
{
#ifdef BR_BUILD_WIN
	// The timerChore has to be deleted because it isn't a subview of the desktop  
	delete fWinTimerChore;
#endif
}

//-----------------------------------------------------------------------------------
// cEditApp::CreateDocument
//
// Creates a new document.
//-----------------------------------------------------------------------------------

BR_CDocument* cEditApp::CreateDocument()
{
	// Create a document
	cEditDoc *document = new cEditDoc(this);

	// Create a window for the document
	document->NewWindow();
	
	// Create a file for the document
	document->NewFile();
	
	// Show the window
	document->GetWindow(0)->Show();
	
	return document;
}

//-----------------------------------------------------------------------------------
// cEditApp::OpenDocument
//
// Opens an existing document.
//-----------------------------------------------------------------------------------

BR_CDocument* cEditApp::OpenDocument(BR_CFileSpecification &fileSpec)
{
	// Create a document
	cEditDoc *document = new cEditDoc(this);

	// Create a window for the document
	document->NewWindow();
	
	// Open the file for this document
	if (document->OpenFile(fileSpec))
	{
		// Show the window
		document->GetWindow(0)->Show();
		
		return document;
	}
	
	delete document;
	return NULL;
}

//-----------------------------------------------------------------------------------
// cEditApp::MakeAppDesktop
//
// Makes the Application Desktop. Creates a BR_CTimerChore and a cEdStatusBar.
//-----------------------------------------------------------------------------------

BR_CAppDesktop* cEditApp::MakeAppDesktop()
{
	BR_CAppDesktop *appDesktop = BR_CApplication::MakeAppDesktop();
	
#ifdef BR_BUILD_WIN
	// Create a new status bar at the bottom of the desktop
	// This status bar contains sub-views to display help status,
	// line and column status, and the current time.
	fWinEdStatusBar = new cEdStatusBar(appDesktop);

	// Create a BR_CTimerChore to display the current time on the status bar
	fWinTimerChore = new BR_CTimerChore(fWinEdStatusBar);
	AssignChore(fWinTimerChore);
#endif

	return(appDesktop);
}

//-----------------------------------------------------------------------------------
// cEditApp::UpdateMenus
//
// Called when the menus are activated.
//-----------------------------------------------------------------------------------

void cEditApp::UpdateMenus(BR_CMenuBar& menuBar, BR_Boolean fCallSupervisor)
{
	BR_CApplication::UpdateMenus(menuBar, fCallSupervisor);

	menuBar.EnableCmd(cmdAboutBox);
}

//-----------------------------------------------------------------------------------
// cEditApp::DoCommand
//
// Handles menu commands.
//-----------------------------------------------------------------------------------

BR_Boolean cEditApp::DoCommand(CommandId cmdId, 
						 	   BR_CObject *notifier,
							   BR_Boolean fCallSupervisor)
{
	BR_Boolean commandHandled = TRUE;

	switch(cmdId)
	{
      	case cmdAboutBox:
			DoAboutBox();
         	break;
			
      	default:
         	commandHandled=BR_CApplication::DoCommand(cmdId,
													  notifier,
													  fCallSupervisor);
	}
    return commandHandled;
}

//-----------------------------------------------------------------------------------
// cEditApp::ShowHelpStatusString
//
// Shows a help string in the application's status bar.
//-----------------------------------------------------------------------------------

BR_Boolean cEditApp::ShowHelpStatusString(const BR_TString<BR_Char>& helpStatusString)
{
#ifdef BR_BUILD_WIN
	GetStatusBar()->GetHelpRect().SetText(helpStatusString);
#endif

	return TRUE;
}

#ifdef BR_BUILD_WIN

//-----------------------------------------------------------------------------------
// cEditApp::GetStatusBar
//
// Returns a pointer to the application's status bar.
//-----------------------------------------------------------------------------------

cEdStatusBar* cEditApp::GetStatusBar()
{
   return fWinEdStatusBar;
}
#endif

//-----------------------------------------------------------------------------------
// cEditApp::DoAboutBox
//
// Creates an about box for the program.
//-----------------------------------------------------------------------------------

void cEditApp::DoAboutBox()
{
	BR_CDialogDirector aboutBoxDialog(this, NULL, *GetApplication(), IDV_ABOUTBOX_DIALOG);
   	aboutBoxDialog.ShowDialog();
}
