//========================================================================================
//
//     File:		QTViews.h
//     Release Version:	$Revision$
//
//     Original Author:	Craig Hansen-Sturm
//     Creation Date:	March 16, 1993
//
//     COPYRIGHT 1993 APPLE COMPUTER CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF APPLE COMPUTER
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF APPLE COMPUTER CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Apple Computer Corporation, 20525 Mariani Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   QTVIEWS_H
#define   QTVIEWS_H

#ifndef   QTCONTRL_H
#include "QTContrl.h"
#endif

#ifndef   QTMOVIE_H
#include "QTMovie.h"
#endif

#ifndef   WCPANE_H
#include "wcpane.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class QT_CMovieControlBarPlaybackView;

//========================================================================================
// CLASS QT_CMoviePlaybackViewEnvelope
//========================================================================================

class QT_CMoviePlaybackViewEnvelope : public QT_CMoviePlaybackControllerEnvelope
{
public:
			// MC action commands
			void 													Play() ;                    
			void 													Stop() ;
			void 													Rewind(TimeRecord *aTime = 0) ;       // $$$$ rewind to a previous time value, an extension to the QT API
			void 													FastForward(TimeRecord *aTime = 0) ; // $$$$ fast forward to a future time value, an extension to QT API
			void 													GoTo(TimeRecord *aTime = 0) ;
			
		  void 													EnablePlayEveryFrame() ;
			void 													DisablePlayEveryFrame() ;
			BOOL 													IsPlayEveryFrameEnabled() const ;
			
			void 													EnableBadge() ;
			void 													DisableBadge() ;
			BOOL 													IsBadgeEnabled() const ;
			
			void 													EnableKeys() ;
			void 													DisableKeys() ;
			BOOL 													AreKeysEnabled() const ;
			
			void 													EnableLooping() ;
			void 													DisableLooping() ;
			BOOL 													IsLoopingEnabled() const ;
			
			void 													EnablePalindromeLooping() ;
			void 													DisablePalindromeLooping() ;
			BOOL 													IsPalindromeLoopingEnabled() const ;
			
			void 													EnablePlaySelection() ;
			void 													DisablePlaySelection() ;
			BOOL 													IsPlaySelectionEnabled() const ;
			
			void 													SetVolume(AmplitudeValue aVolume = 0) ;
			AmplitudeValue 								GetVolume() const ;
			
			void 													SetPlayRate(TimeValue aRate = 0) ;
			TimeValue 										GetPlayRate() const ;
			
			void 													SetStepValue(StepValue aStepValue = 1) ;
			StepValue 										GetStepValue() const ;
			
			void 													SetSelectionStartTime(TimeRecord *aStartTime = 0) ;
			TimeRecord *									GetSelectionStartTime() const ;

			void  												SetSelectionDuration(TimeRecord *aDuration = 0) ;
			TimeRecord *									GetSelectionDuration() const ;
			
			void 													SetPosterTime(TimeRecord *aTime = 0) ;
			TimeRecord *									GetPosterTime() const ;
			
			// Interface to the Controller
			
			QT_CMoviePlaybackController * GetController() const;

protected:
			// constructors/destructors
																		QT_CMoviePlaybackViewEnvelope();
																		~QT_CMoviePlaybackViewEnvelope();
																		
			QT_CMoviePlaybackController * fMyPlaybackController;
};

//========================================================================================
// CLASS QT_CMovieScreenPlaybackView
//========================================================================================

class QT_CMovieScreenPlaybackView : public cPane, public QT_CMoviePlaybackViewEnvelope
{
public:

			// constructors/destructors
																			QT_CMovieScreenPlaybackView(
																				cView * aEnclosure, 
																				cBureaucrat * aSupervisor,
																			  LONG width,
			 																	LONG height,
			 																	LONG x,
			 																	LONG y,
			 																	BEDSIZE fHorizontalSizing,
			 																	BEDSIZE fVerticalSizing,
			 																	BEDXFUNITS units,
																				QT_CMovie* anExistingMovie = NULL);
																				
																			QT_CMovieScreenPlaybackView(
																				cView * aEnclosure, 
																				cBureaucrat * aSupervisor, 
																	  		LONG width,
			 																	LONG height,
			 																	LONG x,
			 																	LONG y,
			 																	BEDSIZE fHorizontalSizing,
			 																	BEDSIZE fVerticalSizing,
			 																	BEDXFUNITS units,
																				QT_CMovieScreenPlaybackView * anExistingMovieView);
																				
																			QT_CMovieScreenPlaybackView(
																				cView * aEnclosure, 
																				cBureaucrat * aSupervisor,
																	  		LONG width,
			 																	LONG height,
			 																	LONG x,
			 																	LONG y,
			 																	BEDSIZE fHorizontalSizing,
			 																	BEDSIZE fVerticalSizing,
			 																	BEDXFUNITS units,
																				QT_CMovieControlBarPlaybackView * anExistingMovieView);
																				
			virtual 												~QT_CMovieScreenPlaybackView();
				
			// Bedrock View Hierarchy Interface

protected:

			virtual void 			  					Draw(const cRectangle& pArea);
			virtual void 			  					Move(const cRectangle& pArea, BOOL fRedraw);
			virtual BOOL	  								DoCommand(unsigned short cmdId,
																							cObject * notifier,
												  										BOOL fCallSupervisor = TRUE);
			virtual void        						Activate();
			virtual void				  					Deactivate();
			
			unsigned												AttachView();
			unsigned												AttachView(QT_CMovie *anExistingMovie);
			unsigned 											AttachView(QT_CMovieScreenPlaybackView *anExistingMovieView);
			unsigned 											AttachView(QT_CMovieControlBarPlaybackView *anExistingMovieView);
			unsigned 											DetachView();
				
			// MoviePlaybackControllerEnvelope Interface Extensions
			
public:

			void 														ShowMovieFrame();
			void 														HideMovieFrame();
			BOOL 														IsMovieFrameHidden() const;
				
			void 														SetMaxScreenSize(cRectangle & aRect);
			cRectangle & 										GetMaxScreenSize() const;

	// SETCLASSNAME(QT_CMovieScreenPlaybackView);
};

//========================================================================================
// CLASS QT_CMovieControlBarPlaybackView
//========================================================================================

class QT_CMovieControlBarPlaybackView : public cPane, public QT_CMoviePlaybackViewEnvelope
{
public:

			// constructors/destructors
																				QT_CMovieControlBarPlaybackView(
																					cView * aEnclosure, 
																					cBureaucrat * aSupervisor,
																	  			LONG width,
			 																		LONG height,
			 																		LONG x,
			 																		LONG y,
			 																		BEDSIZE fHorizontalSizing,
			 																		BEDSIZE fVerticalSizing,
			 																		BEDXFUNITS units,
																					QT_CMovie* anExistingMovie = NULL);
																					
																			  QT_CMovieControlBarPlaybackView(
																					cView * aEnclosure, 
																					cBureaucrat * aSupervisor, 
																	  			LONG width,
			 																		LONG height,
			 																		LONG x,
			 																		LONG y,
			 																		BEDSIZE fHorizontalSizing,
			 																		BEDSIZE fVerticalSizing,
			 																		BEDXFUNITS units,
																					QT_CMovieScreenPlaybackView * anExistingMovieView);
																					
			virtual 													~QT_CMovieControlBarPlaybackView();
				
			// Bedrock View Hierarchy Interface

protected:

			virtual void 			  						Draw(const cRectangle& pArea);
			virtual void 			  						Move(const cRectangle& pArea, BOOL fRedraw);
			virtual BOOL	  									DoCommand(unsigned short cmdId,
																	  			cObject * notifier,
												  				  			BOOL fCallSupervisor = TRUE);
			virtual void        							Activate();
			virtual void				  						Deactivate();
			
			unsigned													AttachView();
			unsigned													AttachView(QT_CMovie *anExistingMovie);
			unsigned 												AttachView(QT_CMovieScreenPlaybackView *anExistingMovieView);
			unsigned 												DetachView();
			
			// MoviePlaybackControllerEnvelope Interface Extensions

public:

			void 															ShowSpeakerButton();
			void 															HideSpeakerButton();
			BOOL 															IsSpeakerButtonHidden() const;
			
			void 															ShowStepButtons();
			void 															HideStepButtons();
			BOOL 															AreStepButtonsHidden() const;
			
	// SETCLASSNAME(QT_CMovieControlBarPlaybackView);
};

//========================================================================================
//	CLASS QT_CMovieStandardPlaybackView
//========================================================================================

class QT_CMovieStandardPlaybackView : public cPane, public QT_CMoviePlaybackViewEnvelope
{		
	public:
	
		// constructors/destructors
	  																	QT_CMovieStandardPlaybackView(cView* aEnclosure, cBureaucrat* aSupervisor, QT_CMovie* anExistingMovie = NULL);
																			
	  																	QT_CMovieStandardPlaybackView(
																				cView* aEnclosure, 
																				cBureaucrat* aSupervisor,
																	  		LONG width,
			 																	LONG height,
			 																	LONG x,
			 																	LONG y,
			 																	BEDSIZE fHorizontalSizing,
			 																	BEDSIZE fVerticalSizing,
			 																	BEDXFUNITS units,
																				QT_CMovie* anExistingMovie = NULL);			
																				
		virtual														~QT_CMovieStandardPlaybackView();
		
	private:
	
		QT_CMovieScreenPlaybackView 			*fMyScreenView;
		QT_CMovieControlBarPlaybackView 	*fMyControlBarView;
		
//	 SETCLASSNAME(QT_CMovieStandardPlaybackView);
};

//========================================================================================
//	INLINE METHODS
//========================================================================================

inline QT_CMoviePlaybackController * QT_CMoviePlaybackViewEnvelope::GetController() const
{
	return fMyPlaybackController;
}

#endif // QTVIEWS_H
