//========================================================================================
//
//     File:		QTMVFile.h
//     Release Version:	$Revision$
//
//     Original Author:	Lou Infeld
//     Windows Version: Craig Hansen-Sturm
//     Creation Date:	March 30, 1993
//
//     COPYRIGHT 1993 APPLE COMPUTER CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF APPLE COMPUTER
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF APPLE COMPUTER CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Apple Computer Corporation, 20525 Mariani Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef QTMVFILE_H
#define QTMVFILE_H

#ifndef WCOBJECT_H
#include <wcobject.h>
#endif

#ifndef WCFILSPC_H
#include <wcfilspc.h>
#endif

#ifdef  BUILD_WIN

#ifndef WCOPENFL_H
#include <wcopenfl.h>
#endif  // WCOPENFL_H

#ifndef __QTW_H__
#include <Qtw.h>
#endif  // QTW_H

#endif // BUILD_WIN

#ifdef  BUILD_MAC
#ifndef __MOVIES__
#include <Movies.h>
#endif
#endif // BUILD_MAC

//========================================================================================
// Forward Class Declarations
//========================================================================================

class cBureaucrat;

//========================================================================================
// CLASS QT_CMovieFile
//
//		Encapsulates a Movie File as supported by the Movie ToolBox.
//
//========================================================================================


class QT_CMovieFile : public cObject
{
	public:
	
		// Constructors
										QT_CMovieFile();
										QT_CMovieFile(const cFileSpec& fileSpec);
									
		// Destructor

		virtual			 ~QT_CMovieFile();
	
		// High level Interface
		
					Movie			AskUserForMovie(cBureaucrat *aSupervisor = NULL);
					BOOL			AskUserForFile(cBureaucrat *aSupervisor = NULL);
					Movie			GetMovieFromFile(
											short newMovieFlags = newMovieActive, 
											BOOL *wereDataRefsChanged = 0 );
					void			SaveMovieToFile(
											Movie movie, 
											cFileSpec *fileSpec = 0 );

		//	Class getters
		
					cStr255		GetName() const;
					size_t		GetSize() const;
					
		// Low level Interface
		
					void			Open();
					void			Create(Movie *newMovie = 0);
					void			Close();
					void			Delete();
					Movie			NewMovieFromFile(
											short newMovieFlags = newMovieActive, 
											BOOL *wereDataRefsChanged = 0 );
					Movie			NewMovieFromDataFork(
											long fileOffset = 0, 
											short newMovieFlags = newMovieActive, 
											BOOL *wereDataRefsChanged = 0 );
										
#ifdef BUILD_MAC			
					void			BedMacSetCreator(OSType creator);
					void			BedMacSetScriptTag(ScriptCode scriptTag);
					void			BedMacSetCreateFileFlags(long flags);
					void			BedMacSetMovieFlattenFlags(long flags);
					void			BedMacAddMovieToFile(Movie movie);
					void			BedMacRemoveMovieFromFile();
					void			BedMacUpdateMovieInFile(Movie movie);
					void			BedMacConvertMovieToFile(Movie movie);
					void			BedMacPutMovieIntoDataFork(
											Movie movie, 
											long fileOffset = 0, 
											long maxSize = 0 );
					void			BedMacFlattenMovieToFile(
											Movie movie, 
											cFileSpec *fileSpec = 0);
					Movie			BedMacFlattenMovie(Movie movie, cFileSpec *fileSpec);
#endif // BUILD_MAC					

	private:
	
					void			Init();
	
		cFileSpec				fFileSpec;
		short						fRefNum;
		short						fResID;
		cStr255					fResName;
		int						  fFilePermissions;
		
#ifdef BUILD_WIN		
		UINT						fResRefNum;
#endif // BUILD_WIN			

#ifdef BUILD_MAC		
		short						fResRefNum;
		OSType					fCreator;
		ScriptCode			fScriptTag;
		long						fCreateFileFlags;
		long						fMovieFlattenFlags;
#endif	// BUILD_MAC
		
	 								BR_SETCLASSNAME(QT_CMovieFile);		
};

//========================================================================================
//	INLINE METHODS
//========================================================================================

#ifdef BUILD_MAC
inline void QT_CMovieFile::BedMacSetCreator(OSType creator)
{
	fCreator = creator;
}

inline void QT_CMovieFile::BedMacSetScriptTag(ScriptCode scriptTag)
{
	fScriptTag = scriptTag;
}

inline void QT_CMovieFile::BedMacSetCreateFileFlags(long flags)
{
	fCreateFileFlags = flags;
}

inline void QT_CMovieFile::BedMacSetMovieFlattenFlags(long flags)
{
	fMovieFlattenFlags = flags;
}
#endif // BUILD_MAC

#endif // QTMVFILE_H
