//========================================================================================
//
//     File:		QTMVDoc.h
//     Release Version:	$Revision$
//
//     Original Author:	Lou Infeld/Craig Hansen-Sturm
//     Creation Date:	March 18, 1993
//
//     COPYRIGHT 1993 APPLE COMPUTER CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF APPLE COMPUTER
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF APPLE COMPUTER CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Apple Computer Corporation, 20525 Mariani Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef QTMVDOC_H
#define QTMVDOC_H

#ifndef WCDOCMNT_H
#include <wcdocmnt.h>
#endif

#ifndef   QTMOVIE_H
#include <QTMovie.h>
#endif

#ifndef   QTVIEWS_H
#include <QTViews.h>
#endif

//========================================================================================
// CLASS QT_CMovieApplication
//
//		Provides a simple document interface to play back movies
//
//========================================================================================

class QT_CMovieDocument : public cDocument
{
	public:
	
							QT_CMovieDocument();
							~QT_CMovieDocument();

		virtual void		NewWindow();
		virtual BOOL		OpenFile(cFileSpec& fileSpec);
		virtual BOOL		IsDirty() const;
		virtual BOOL   Quit();
		
	private:
	  				 void   Finalize();		
	
		QT_CMovie 										*fMovie;
		QT_CMovieStandardPlaybackView *fMovieView;
	  cDocWindow 										*fMovieDoc;
		
	 SETCLASSNAME(QT_CMovieDocument);
};

inline BOOL QT_CMovieDocument::IsDirty() const
{
	return fMovie->HasMovieChanged();
}

#endif // QTMVDOC_H