#if !defined(BRTRACE_H) && defined(BR_DEBUG)
#define BRTRACE_H
// This entire file is for debugging only
//========================================================================================
//
//	File:				BRTrace.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		12/10/92
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//	THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#include <iostream.h>

#ifndef   BRTRACET_H
#include "BRTraceT.h"
#endif

//========================================================================================
// CLASS _BR_CTraceRuntime
//========================================================================================

class _BR_CTraceRuntime
{
public:

	static short Initialize(ostream *traceStream);
		// Prepare to trace.  Acquires resources needed for tracing.
		// Client must ensure that traceStream is opened for writing.
		// Returns zero if could not initialize, non-zero if successful.
		
	static void Terminate();
		// Release resources needed for tracing.
		// Client can now close the trace stream.

	static void StartTrace();
		// Starts (resumes) tracing to the trace stream.
		// It is an error to start tracing without successful call to Initialize.
	 
	static void StopTrace();
		// Stops (suspends) tracing to the trace stream.

	static unsigned short GetTraceEnableCount();
	static void SetTraceEnableCount(unsigned short traceEnabled);
	
	static unsigned short GetTraceDepth();
	static void SetTraceDepth(unsigned short traceDepth);
	
	static void IncrTraceDepth();
	static void DecrTraceDepth();
	
	static ostream* GetTraceStream();
	static void SetTraceStream(ostream* traceStream);

#ifdef BR_BUILD_WIN
	static void* GetTraceBuffer();
	static void SetTraceBuffer(void* pTraceBuffer);
	static void TraceIn();
	static void TraceOut();
	
	static void DumpOneLine(ostream& traceStream,
							const char* pzPrefix,
							unsigned hModule,			// HANDLE
							unsigned wSegment,			// WORD
							unsigned wOffset);			// WORD
		// Not using HANDLE & WORD types here because BRTrace.h shouldn't
		// include wbdwin.h, and if it included Windows.h, then there
		// would ultimately be conflicts with wbdwin.h.  We really need
		// to get rid of wbdwin.h!!  JEL???
#endif

	enum StepInOut { kStepIn=0, kStepOut=1};
	static char gPrefixChar[2];

#ifdef BR_BUILD_MAC
	static void TraceIn();
	static void TraceOut();
	static void DumpOneLine(ostream& traceStream,
							  unsigned short depth,
							  StepInOut direction,
							  const char* procName);
#endif

};

//========================================================================================
// _BR_CTraceRuntime inline functions (Static Task Globals Versions)
//========================================================================================

#ifdef BR_STATIC_TASK_GLOBALS

inline unsigned short _BR_CTraceRuntime::GetTraceEnableCount()
{
	return BR_CTraceTaskGlobals::gTraceTaskGlobals.gBedTraceGlobals.gTraceEnabled;
}

inline void _BR_CTraceRuntime::SetTraceEnableCount(unsigned short traceEnabled)
{
	BR_CTraceTaskGlobals::gTraceTaskGlobals.gBedTraceGlobals.gTraceEnabled = traceEnabled;
}

inline unsigned short _BR_CTraceRuntime::GetTraceDepth()
{
	return BR_CTraceTaskGlobals::gTraceTaskGlobals.gBedTraceGlobals.gTraceDepth;
}

inline void _BR_CTraceRuntime::SetTraceDepth(unsigned short traceDepth)
{
	BR_CTraceTaskGlobals::gTraceTaskGlobals.gBedTraceGlobals.gTraceDepth = traceDepth;
}

inline ostream* _BR_CTraceRuntime::GetTraceStream()
{
	return BR_CTraceTaskGlobals::gTraceTaskGlobals.gBedTraceGlobals.gTraceStream;
}

inline void _BR_CTraceRuntime::SetTraceStream(ostream* traceStream)
{
	BR_CTraceTaskGlobals::gTraceTaskGlobals.gBedTraceGlobals.gTraceStream = traceStream;
}

#endif

//========================================================================================
// _BR_CTraceRuntime inline functions (Dynamic Task Globals Versions)
//========================================================================================

#ifndef BR_STATIC_TASK_GLOBALS

inline unsigned short _BR_CTraceRuntime::GetTraceEnableCount()
{
	return BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceEnabled;
}

inline void _BR_CTraceRuntime::SetTraceEnableCount(unsigned short nTraceEnabled)
{
	BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceEnabled = nTraceEnabled;
}

inline unsigned short _BR_CTraceRuntime::GetTraceDepth()
{
	return BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceDepth;
}

inline void _BR_CTraceRuntime::SetTraceDepth(unsigned short traceDepth)
{
	BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceDepth = traceDepth;
}

inline ostream* _BR_CTraceRuntime::GetTraceStream()
{
	return BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceStream;
}

inline void _BR_CTraceRuntime::SetTraceStream(ostream* traceStream)
{
	BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceStream = traceStream;
}

#ifdef BR_BUILD_WIN
inline void* _BR_CTraceRuntime::GetTraceBuffer()
{
	return BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceBuffer;
}

inline void _BR_CTraceRuntime::SetTraceBuffer(void* pTraceBuffer)
{
	BR_CTraceTaskGlobals::GetTaskGlobals()->
						gBedTraceGlobals.gTraceBuffer = pTraceBuffer;
}
#endif

#endif

#endif
