#ifndef BRBEDTAS_H
#define BRBEDTAS_H
//========================================================================================
//
//	File:				BRBedTas.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		12/10/92
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
// 	THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
// 	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as Set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#include <stddef.h>

class BR_CBedTaskGlobals;

#if defined __ZTC__ && (__ZTC__ >= 0x0400)
#define asm __emit__
#endif

//========================================================================================
// STRUCT BR_SBedTaskGlobalsHeader
//
//	By convention, the task globals area has this header structure.
//
//========================================================================================

struct BR_SBedTaskGlobalsHeader
{
	short					gBedTaskGlobalsSize;
	BR_CBedTaskGlobals 		*gThis;
};

//========================================================================================
// CLASS BR_CBedTaskGlobals
//
//	An interface for per task globals.  A set of DLLs and an application can share task
//	specific global data using this interface.
//	
//	This class lays out globals that Bedrock DLLs "share".  Assume that Bedrock is
//	partitioned into the three traditional DLLs (BCLUTIL, BCL, BCLADV), and that we
//  add a fourth DLL by removing BEL from BCLUTIL.  Furthermore, we'd like BEL to be
//	usable by applications that may not be built upon the other DLLs.  BEL needs to have
//  task specific globals, without making assumptions about the DLLs and applications that
//	use it.  We achieve this by requiring the following:
//
//		1) We can "reserve" a space in the application's data segment just above the
//		header and below the static data area (alternatively, we can say that we are
//		reserving the first portion of the static data area).
//		2) Within this space, we can reserve space for components like BEL.
//
//	The layout of the data members below must conform to the reserved layout.
//
//	NOTE: Only one instance of a BR_CBedTaskGlobals object should be created, and only
//	by code residing in an .EXE (application).  This class, BR_CBedTaskGlobals, is
//	only meaningful in relation to DLLs, and is therefore defined as an abstract class
//	using a protected constructor.  Application code should define a subclass with a 
//	public constructor, and arrange to create one such instance (See AppTaskG & StatInit).
//========================================================================================

class BR_CBedTaskGlobals
{

public:

	void* 						operator new(size_t);
	void 						operator delete(void* storage);

	static BR_CBedTaskGlobals*		GetTaskGlobals();

	// The size of the task globals data area is the 256 bytes + signature.
	enum {kTaskGlobalsAreaSize = 256 + sizeof(long)};

#ifdef BR_STATIC_TASK_GLOBALS
	static union uTaskGlobalArea
	{
		unsigned long			_Signature;
		char					_DataArea[BR_CBedTaskGlobals::kTaskGlobalsAreaSize];
	} gTaskGlobalArea;
#endif

	unsigned long 				gTaskGlobalsSignature;
	BR_SBedTaskGlobalsHeader		gBedTaskGlobalsHeader;

								~BR_CBedTaskGlobals();

protected:
								BR_CBedTaskGlobals();

#ifdef BR_BUILD_MAC
private:
	static void*				MacGetTaskGlobals();
#endif
};

const unsigned long kTaskGlobalsSignature = 0x5357564B;	// 'SWVK'

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_WinGetTaskGlobals
//----------------------------------------------------------------------------------------
inline void* BR_WinGetTaskGlobals()
{
					asm(0x8C, 0xD2);			// mov DX, SS		2 cycles
#ifndef __BORLANDC__
	return (void*)	
#endif
	asm(0xB8, 0x10, 0x00);		// mov AX, 10h		2 cycles
}
#endif


//----------------------------------------------------------------------------------------
//	GetTaskGlobals
//----------------------------------------------------------------------------------------

inline BR_CBedTaskGlobals* BR_CBedTaskGlobals::GetTaskGlobals()
{
#if defined(BR_BUILD_MAC)
	return (BR_CBedTaskGlobals*) MacGetTaskGlobals();
#elif defined(BR_BUILD_WIN)
	return (BR_CBedTaskGlobals*) BR_WinGetTaskGlobals();
#endif
}

#endif

