#ifndef BRVM_H
#define BRVM_H
/*========================================================================================
/
/     File:				BRVM.h
/     Release Version:	$ 1.0d1 $
/
/     Creation Date:	3/3/90
/
/     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/
/     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/
/     RESTRICTED RIGHTS LEGEND
/     Use, duplication, or disclosure by the Government is subject to restrictions as Set
/     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/     Cupertino, CA 95014.
/
/=======================================================================================*/

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifdef __cplusplus
  extern "C" {
#endif

#define BEDVM_RESTYPE   741
#define BEDVM_RESCODE   147

typedef unsigned short BR_VMVersion;


typedef enum
 {
   BR_VMError_kNoMemoryError,
   BR_VMError_kRealModeMemoryError,
   BR_VMError_kReallocateFailedMemoryError,
   BR_VMError_kAllocationTooLargeMemoryError,
   BR_VMError_kBlockTooBigMemoryError,
   BR_VMError_kOutOfMemoryError,
   BR_VMError_kLockMemoryError,
   BR_VMError_kBadBucketMemoryError,
   BR_VMError_kZeroLengthAllocationMemoryError,
   BR_VMError_kBadHandleMemoryError,
   BR_VMError_kNullPointerMemoryError,
   BEDVMU_BADPOINTER
} BR_VMError;

#ifdef BR_BUILD_WIN

typedef enum
{
	kFixedMemory 		= LMEM_FIXED,
	kMoveableMemory 	= LMEM_MOVEABLE,
	kDiscardableMemory 	= LMEM_DISCARDABLE,
	kNoCompactMemory  	= LMEM_NOCOMPACT,
	kNoDiscardMemory 	= LMEM_NODISCARD,
	kZeroInitMemory		= LMEM_ZEROINIT,
	kDiscardedMemory    = LMEM_DISCARDED,
	kModifyMemory		= LMEM_MODIFY,
	kLockCountMemory 	= LMEM_LOCKCOUNT
} BR_VMMemoryFlags;

#define BR_VMFlags_kFixedMemory              LMEM_FIXED
#define BR_VMFlags_kMoveableMemory           LMEM_MOVEABLE
#define BR_VMFlags_kDiscardableMemory        LMEM_DISCARDABLE
#define BR_VMFlags_kNoCompactMemory          LMEM_NOCOMPACT
#define BR_VMFlags_kNoDiscardMemory          LMEM_NODISCARD
#define BR_VMFlags_kZeroInitMemory           LMEM_ZEROINIT
#define BR_VMFlags_kDiscardedMemory          LMEM_DISCARDED
#define BR_VMFlags_kModifyMemory             LMEM_MODIFY
#define BR_VMFlags_kLockCountMemory          LMEM_LOCKCOUNT

#endif

/* Virtual Memory Manager Procedures */
BR_EXPORTENTRY(BR_VMVersion)  BR_VMGetVersion(void);
BR_EXPORTENTRY(BR_Boolean) BR_VMRegister(unsigned short count, 
                                        unsigned short FAR * pSizes);
BR_EXPORTENTRY(BR_Boolean) BR_VMTerminate(void);
BR_EXPORTENTRY(void) BR_VMInitialize (void);


BR_EXPORTENTRY(BR_VMHandle) BR_VMAllocate(unsigned long request);
BR_EXPORTENTRY(void FAR *)  BR_VMNonRelocatableAllocate(unsigned long request);
/* This procedure is currently commented out for future modification - RAB
 BR_EXPORTENTRY(BR_VMHandle) BR_VMFullAllocate(PBEDVMBUCKET fBucket,
                                            WORD wFlags,
											unsigned short request);
*/

BR_EXPORTENTRY(BR_Boolean) BR_VMFree(BR_VMHandle h);
BR_EXPORTENTRY(BR_Boolean) BR_VMNonRelocatableFree (void FAR * p);

BR_EXPORTENTRY(LPVOID) BR_VMNonRelocatableResizeMove (void FAR * p, unsigned long request);
BR_EXPORTENTRY(BR_VMHandle) BR_VMResize(BR_VMHandle h, unsigned long request);
BR_EXPORTENTRY(BR_VMHandle) BR_VMFullReallocate(BR_VMHandle h, 
                               	             unsigned long request, 
									    	 unsigned short wFlags);

/* This procedure is currently commented out for future modification - RAB
  BR_EXPORTENTRY(BEDVMERR) BR_VMNonRelocatableResize (void FAR * p, long newRequest);
*/

/* This procedure is currently commented out for future modification - RAB
  BR_EXPORTENTRY(PVOID) BR_VMExtendedLock (BR_VMHandle h, long pos, long len);
  BR_EXPORTENTRY(VOID) BR_VMClearLocks(BR_VMHandle h);
*/
BR_EXPORTENTRY(BR_Boolean) BedVMUnlock(BR_VMHandle h);
BR_EXPORTENTRY(LPVOID) BR_VMLock(BR_VMHandle h);


BR_EXPORTENTRY(unsigned long) BR_VMNonRelocatableGetSize(void FAR * p);
BR_EXPORTENTRY(BR_Boolean) BR_VMIsFixedSize (void FAR * p);
BR_EXPORTENTRY(BR_VMHandle) BR_VMGetHandle(void FAR * p);
BR_EXPORTENTRY(unsigned short) BR_VMGetFlags(BR_VMHandle h);
BR_EXPORTENTRY(unsigned long) BR_VMGetSize(BR_VMHandle h);

/* This procedure is currently commented out for future modification - RAB
  BR_EXPORTENTRY(long) BedVMBucketSetFreestoreThreshold(PBEDVMBUCKET fBucket,
       long lNewThreshold);
*/

BR_EXPORTENTRY(BR_VMError) BR_VMGetError(void);

BR_EXPORTENTRY(void FAR *) BR_VMClearMemory (void FAR * p, long len);

/* OS Handle Functions */


BR_EXPORTENTRY(BR_PlatformHandle) BR_VMOperatingSystemAllocate(unsigned long request);
BR_EXPORTENTRY(BR_Boolean) BR_VMOperatingSystemFree(BR_PlatformHandle h);
BR_EXPORTENTRY(BR_PlatformHandle) BR_VMOperatingSystemResize(BR_PlatformHandle h, 
    											   unsigned long request);
BR_EXPORTENTRY(void FAR *) BR_VMOperatingSystemLock(BR_PlatformHandle h);
BR_EXPORTENTRY(BR_Boolean) BR_VMOperatingSystemUnlock(BR_PlatformHandle h);
BR_EXPORTENTRY(unsigned long) BR_VMOperatingSystemGetSize(BR_PlatformHandle h);
BR_EXPORTENTRY(BR_PlatformHandle) BR_VMMakeOSFromHandle(BR_VMHandle h);
BR_EXPORTENTRY(BR_PlatformHandle) BR_VMMakeOSFromPointer(void FAR * p, unsigned long len);
BR_EXPORTENTRY(BR_VMHandle) BR_VMMakeHandleFromOS(BR_PlatformHandle h);
BR_EXPORTENTRY(void FAR *) BR_VMMakePointerFromOS(BR_PlatformHandle h);

#ifdef BR_BUILD_WIN
BR_EXPORTENTRY(BR_Boolean) BR_VMDebugWalkCheckLocalPage(unsigned short Page);
BR_EXPORTENTRY(void) BR_VMDebugDoCheckPage(unsigned short Page);
BR_EXPORTENTRY(BR_Boolean) BR_VMDebugValidatePointer(void FAR * p);
BR_EXPORTENTRY(BR_Boolean) BR_VMDebugValidateOSHandle(BR_PlatformHandle h);
BR_EXPORTENTRY(BR_Boolean) BR_VMDebugValidateHandle(BR_VMHandle h);
#endif

BR_EXPORTENTRY(void)   BR_VMMemorySet(void FAR *dest, unsigned char Value, 
								   unsigned short len);
BR_EXPORTENTRY(void)   BR_VMMemoryMove(void FAR *dest, void FAR *src, unsigned short len);
BR_EXPORTENTRY(short)  BR_VMMemoryCompare (void FAR *src1, void FAR *src2, unsigned short len);
BR_EXPORTENTRY(unsigned short) BR_VMMemoryCRC(void FAR *src, 
										  unsigned short len, 
										  unsigned short init_crc);

#ifdef __cplusplus
   }
#endif

#endif

