/*========================================================================================
/ 
/      File:		BRValida.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	March 4, 1990
/ 
/      COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/

/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/


#ifndef   BRVALIDA_H
#define   BRVALIDA_H

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef   BRINTL_H
#include "BRIntl.h"
#endif

#ifndef   BRTIME_H
#include "BRTime.h"
#endif

#ifdef __cplusplus
  extern "C" {
#endif

typedef enum {
   BR_ValErr_kNoError,
   BR_ValErr_kItemUsed,
   BR_ValErr_kOutOfOrder,
   BR_ValErr_kTooManyNumberFields,
   BR_ValErr_kTooFewValues,
   BR_ValErr_kBadPunctuation,
   BR_ValErr_kInvalidPunctuation,
   BR_ValErr_kHourValueInvalid,
   BR_ValErr_kMinuteValueInvalid,
   BR_ValErr_kSecondValueInvalid,
   BR_ValErr_kHundredthValueInvalid,
   BR_ValErr_kAMorPMon24HourClock,

   BR_ValErr_kDigitsAfterClosingParen,
   BR_ValErr_kNoDigitsAfterNumberSeparator,
   BR_ValErr_kTooManyOpenParen,
   BR_ValErr_kOpenParenAfterDigits,
   BR_ValErr_kInvalidClosingParen,
   BR_ValErr_kTooManyClosingParen,
   BR_ValErr_kNoDigitsWithinParen,
   BR_ValErr_kTooManySignIndicators,
   BR_ValErr_kNoDigitsBetweenNumberSeparators,
   BR_ValErr_kNoDigitBeforeNumberSeparator,
   BR_ValErr_kNumberSperatorBeforeDigits,
   BR_ValErr_kTooManuDecimalSeparators,
   BR_ValErr_kNoDigitsFound,
   BR_ValErr_kMissingClosingParen,
   BR_ValErr_kOverflow,
   BR_ValErr_kUnderflow,			/*The Value is less then the types min*/
   BR_ValErr_kNoDecimalInAnInteger,		/*No Decimals in an integer*/
   BR_ValErr_kNoCurrencyHere,		/*This number should not have currency*/
   BR_ValErr_kTooManyDigits,		/*The number has too many digits*/
   BR_ValErr_kItemNotFound,
   BR_ValErr_kFunctionNotSupported
   } BR_ValidationError;


typedef enum {
   BR_ValParseTypes_kNoType,
   BR_ValParseTypes_kDigitRun,
   BR_ValParseTypes_kSpaceRun,
   BR_ValParseTypes_kTabRun,
   BR_ValParseTypes_kOpenParen,
   BR_ValParseTypes_kCloseParen,
   BR_ValParseTypes_kMinus,
   BR_ValParseTypes_kPlus,
   BR_ValParseTypes_kNumberSeparator,
   BR_ValParseTypes_kDecimalSeparator,
   BR_ValParseTypes_kCurrencySymbol
   } BR_ValidationParseTypes;


typedef struct BR_SValidationError
   {
   BR_ValidationError fErrorNumber;
   short fStringPosition;
   void FAR * fAuxilaryPointer;
   } BR_SValidationError, FAR * BR_SValidationErrorPtr;


BR_EXPORTENTRY(BR_Boolean) BR_ValidAlpha (
BR_StringPtr str,
BS_StringLength cnt,
BR_Boolean typeSpecific,
BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidStringCharacterRange (
   BR_StringPtr str,
   BS_StringLength cnt,
   BR_StringCharacter start,
   BR_StringCharacter fEnd,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidUpperCase (
	BR_StringPtr str,
	BS_StringLength cnt,
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidLowerCase (
	BR_StringPtr str,
	BS_StringLength cnt,
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidNumeric (
	BR_StringPtr str,
	BS_StringLength cnt,
	BR_CharacterAttributes myType,
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidBedStringKeyword (
   BR_BedString str,
   unsigned short listLen,
   unsigned short listElemSize,
   BR_BedString list,
   unsigned short FAR * returnVal,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidLong (
	BR_StringPtr str,
	BS_StringLength cnt,
	long FAR * returnVal,
	BR_SValidationErrorPtr err);
	
BR_EXPORTENTRY(BR_Boolean) BR_ValidULong (
	BR_StringPtr str,
	BS_StringLength cnt,
	unsigned long FAR * returnVal, 
	BR_SValidationErrorPtr err);
	
BR_EXPORTENTRY(BR_Boolean) BR_ValidShort (
	BR_StringPtr str,
	BS_StringLength cnt,
	short FAR * returnVal,
	BR_SValidationErrorPtr err);
	
BR_EXPORTENTRY(BR_Boolean) BR_ValidUShort (
	BR_StringPtr str,
	BS_StringLength cnt,
	unsigned short FAR * returnVal,
	BR_SValidationErrorPtr err);
	
BR_EXPORTENTRY(BR_Boolean) BR_ValidFloat (
	BR_StringPtr str, 
	BS_StringLength cnt,
	BR_FloatPtr returnVal,
	BR_SValidationErrorPtr err);
	
BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidFloat (
	BR_BedString str,
	BR_FloatPtr returnVal,
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidLong (
	BR_BedString str,
	long FAR * returnVal, 
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidShort (
	BR_BedString str,
	short FAR * returnVal,
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidUShort (
	BR_BedString str,
	unsigned short FAR * returnVal,
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidIntegerSeries (
   long val,
   unsigned short listLen,
   long FAR * list,
   unsigned short FAR * returnPos);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidIntegerSeries (
   BR_BedString str,
   unsigned short listLen,
   long FAR * list,
   unsigned short FAR * returnPos,
   long FAR * returnVal,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidFloatSeries (
   BR_Float val,
   unsigned short listLen,
   BR_FloatPtr list,
   unsigned short FAR * returnPos);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidFloatSeries (
   BR_BedString str,
   unsigned short listLen,
   BR_FloatPtr list,
   unsigned short FAR * returnPos,
   BR_FloatPtr returnVal,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidIntegerRange (
   long val,
   long start,
   long fEnd);

BR_EXPORTENTRY(BR_Boolean) BR_StringValidIntegerRange (
	BR_StringPtr str,
	BS_StringLength cnt,
	long start,
	long fEnd,
	long FAR * returnVal, 
	BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidIntegerRange (
   BR_BedString str,
   long start,
   long fEnd,
   long FAR * returnVal,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidFloatRange (
   BR_Float val,
   BR_Float start,
   BR_Float fEnd);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidFloatRange (
   BR_BedString str,
   BR_Float start,
   BR_Float fEnd,
   BR_FloatPtr returnVal,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_StringValidFloatRange (
   BR_StringPtr str,
   BS_StringLength cnt,
   BR_Float start,
   BR_Float fEnd,
   BR_FloatPtr returnVal,
   BR_SValidationErrorPtr err);


/* Date & Time Procedures */

BR_EXPORTENTRY(BR_Boolean) BR_ValidDate (
   BR_StringPtr str,
   BS_StringLength cnt,
   BR_SDateTimePtr returnDT,
   BR_SDateTimePtr actualDT,
   BR_DateTimeSet FAR * validUnits,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidDateRange (
   BR_StringPtr str,
   BS_StringLength cnt,
   BR_SDateTimePtr start,
   BR_SDateTimePtr fEnd,
   BR_SDateTimePtr returnDT,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidTime (
   BR_StringPtr str,
   BS_StringLength cnt,
   BR_SDateTimePtr returnDT,
   BR_SDateTimePtr actualDT,
   BR_DateTimeSet FAR * validUnits,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidTimeRange (
   BR_StringPtr str,
   BS_StringLength cnt,
   BR_SDateTimePtr start,
   BR_SDateTimePtr fEnd,
   BR_SDateTimePtr returnDT,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidDateTime (
   BR_BedString str,
   BR_SDateTimePtr returnDT,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidDateTimeRange (
   BR_BedString str,
   BR_SDateTimePtr start,
   BR_SDateTimePtr fEnd,
   BR_SDateTimePtr returnDT,
   BR_SValidationErrorPtr err);


/* Currency Validation */

BR_EXPORTENTRY(BR_Boolean) BR_ValidCurrency (
   BR_StringPtr str,
   BS_StringLength cnt,
   BR_FloatPtr returnVal,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_BedStringValidCurrency (
   BR_BedString str,
   BR_FloatPtr returnVal,
   BR_SValidationErrorPtr err);

BR_EXPORTENTRY(BR_Boolean) BR_ValidCurrencyRange (
   BR_BedString str,
   BR_Float start,
   BR_Float fEnd,
   BR_FloatPtr returnCurrency,
   BR_SValidationErrorPtr err);


#ifdef __cplusplus
   }
#endif

#endif
